/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.ops.SearchOperation;
import java.io.IOException;

public class SearchOperationsFactory
implements OperationFactory {
    private String vectorCollectionName;
    private VectorValues vectors;
    private SearchOptions searchOptions;

    public SearchOperationsFactory() {
    }

    public SearchOperationsFactory(String vectorCollectionName, VectorValues vectors, SearchOptions searchOptions) {
        this.vectorCollectionName = vectorCollectionName;
        this.vectors = vectors;
        this.searchOptions = searchOptions;
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.vectorCollectionName);
        out.writeObject(this.vectors);
        out.writeObject(this.searchOptions);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.vectorCollectionName = in.readString();
        this.vectors = (VectorValues)in.readObject();
        this.searchOptions = (SearchOptions)in.readObject();
    }

    @Override
    public Operation createOperation() {
        return new SearchOperation(this.vectorCollectionName, this.vectors, this.searchOptions);
    }
}

