/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.ops.BaseMutatingOperation;
import com.hazelcast.vector.impl.ops.PutAllBackupOperation;
import com.hazelcast.vector.impl.ops.VectorEntries;
import com.hazelcast.vector.impl.service.VectorCollectionServiceImpl;
import java.io.IOException;

public class PutAllOperation
extends BaseMutatingOperation
implements PartitionAwareOperation,
MutatingOperation,
BackupAwareOperation,
SelfResponseOperation {
    private VectorEntries vectorEntries;
    private transient VectorCollectionServiceImpl service;
    private transient int currentIndex;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, VectorEntries vectorEntries) {
        super(name);
        this.vectorEntries = vectorEntries;
    }

    @Override
    public void beforeRun() {
        super.beforeRun();
        this.service = (VectorCollectionServiceImpl)this.getService();
    }

    @Override
    public CallStatus call() throws Exception {
        if (this.waited) {
            this.getLogger().finest("Executing after waiting %s", this);
        }
        if (this.shouldWait()) {
            return CallStatus.WAIT;
        }
        if (this.isOffloadable()) {
            this.putBatch();
            if (!this.isDone()) {
                return new PutAllOffload();
            }
        } else {
            this.putAll();
        }
        return CallStatus.RESPONSE;
    }

    private boolean isOffloadable() {
        return this.service.getMaxOffloadedRunNanos() > 0L && this.storage.getConfig().getTotalBackupCount() == 0;
    }

    private void putAll() {
        while (this.currentIndex < this.vectorEntries.size()) {
            DataVectorDocument value = this.vectorEntries.getDocument(this.currentIndex);
            this.storage.set(this.vectorEntries.getKey(this.currentIndex), value.getValue(), value.getVectors());
            ++this.currentIndex;
        }
    }

    private void putBatch() {
        long start = System.nanoTime();
        while (this.currentIndex < this.vectorEntries.size()) {
            DataVectorDocument value = this.vectorEntries.getDocument(this.currentIndex);
            this.storage.set(this.vectorEntries.getKey(this.currentIndex), value.getValue(), value.getVectors());
            ++this.currentIndex;
            if (System.nanoTime() - start < this.service.getMaxOffloadedRunNanos()) continue;
            break;
        }
    }

    private boolean isDone() {
        return this.currentIndex >= this.vectorEntries.size();
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean returnsResponse() {
        return this.service == null || !this.isOffloadable();
    }

    @Override
    public boolean shouldBackup() {
        return this.storage.getConfig().getTotalBackupCount() > 0;
    }

    @Override
    public int getSyncBackupCount() {
        return this.storage.getConfig().getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.storage.getConfig().getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.getName(), this.vectorEntries);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.vectorEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.vectorEntries = (VectorEntries)in.readObject();
    }

    @Override
    public int getClassId() {
        return 7;
    }

    private OperationRunnerImpl getPartitionOperationRunner() {
        return (OperationRunnerImpl)this.getNodeEngine().getOperationService().getOperationExecutor().getPartitionOperationRunners()[this.getPartitionId()];
    }

    private class PutAllOffload
    extends Offload
    implements PartitionSpecificRunnable {
        private final OperationRunnerImpl partitionOperationRunner;

        PutAllOffload() {
            super(PutAllOperation.this);
            this.partitionOperationRunner = PutAllOperation.this.getPartitionOperationRunner();
        }

        @Override
        public void start() {
            this.schedule();
        }

        private void schedule() {
            this.operationService.execute(this);
        }

        @Override
        public void run() {
            try {
                this.partitionOperationRunner.metWithPreconditions(PutAllOperation.this);
                PutAllOperation.this.putBatch();
                if (PutAllOperation.this.isDone()) {
                    PutAllOperation.this.sendResponse(true);
                } else {
                    this.schedule();
                }
            }
            catch (Throwable t) {
                this.partitionOperationRunner.handleOperationError(PutAllOperation.this, t);
            }
        }

        @Override
        public int getPartitionId() {
            return PutAllOperation.this.getPartitionId();
        }
    }
}

