/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.vector.impl.ops.OptimizeOperation;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;

public class OptimizeOperationsFactory
implements OperationFactory {
    private UUID uuid;
    private String vectorCollectionName;
    private String indexName;

    public OptimizeOperationsFactory() {
    }

    public OptimizeOperationsFactory(String vectorCollectionName, String indexName) {
        this.vectorCollectionName = vectorCollectionName;
        this.indexName = indexName;
        this.uuid = UuidUtil.newUnsecureUUID();
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeString(this.vectorCollectionName);
        out.writeString(this.indexName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.vectorCollectionName = in.readString();
        this.indexName = in.readString();
    }

    @Override
    public Operation createOperation() {
        return new OptimizeOperation(this.uuid, this.vectorCollectionName, this.indexName);
    }

    public void setUuid(@Nonnull UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid);
    }

    public String toString() {
        return "OptimizeOperationsFactory{uuid=" + String.valueOf(this.uuid) + ", vectorCollectionName='" + this.vectorCollectionName + "', indexName='" + this.indexName + "'}";
    }
}

