/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.InternalSearchResult;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchResultImpl<K, V>
implements InternalSearchResult<K, V>,
IdentifiedDataSerializable {
    private K key;
    private float score;
    @Nullable
    private V value;
    @Nullable
    private VectorValues vectors;
    private transient int id;

    public SearchResultImpl() {
    }

    public SearchResultImpl(int id, @Nonnull K key, float score) {
        this.id = id;
        this.key = key;
        this.score = score;
    }

    @Override
    public SearchResultImpl<K, V> setValue(V value) {
        this.value = value;
        return this;
    }

    @Override
    public SearchResultImpl<K, V> setVectors(VectorValues vectors) {
        this.vectors = vectors;
        return this;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public VectorValues getVectors() {
        return this.vectors;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeFloat(this.score);
        out.writeObject(this.value);
        out.writeObject(this.vectors);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readObject();
        this.score = in.readFloat();
        this.value = in.readObject();
        this.vectors = (VectorValues)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    public String toString() {
        return "SearchResultImpl{key=" + String.valueOf(this.key) + ", score=" + this.score + ", value=" + String.valueOf(this.value) + ", vectors=" + String.valueOf(this.vectors) + "}";
    }

    @Override
    public int id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResultImpl that = (SearchResultImpl)o;
        return Float.compare(this.score, that.score) == 0 && this.id == that.id && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.vectors, that.vectors);
    }

    public int hashCode() {
        return Objects.hash(this.key, Float.valueOf(this.score), this.value, this.vectors, this.id);
    }
}

