/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.transaction.impl.TargetAwareTransactionLogRecord;
import com.hazelcast.transaction.impl.TransactionLogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;

public class TransactionLog {
    private final Map<Object, TransactionLogRecord> recordMap = new HashMap<Object, TransactionLogRecord>();

    public TransactionLog() {
    }

    public TransactionLog(Collection<TransactionLogRecord> transactionLog) {
        for (TransactionLogRecord transactionLogRecord : transactionLog) {
            this.add(transactionLogRecord);
        }
    }

    public void add(TransactionLogRecord transactionLogRecord) {
        Object key = transactionLogRecord.getKey();
        if (key == null) {
            key = new Object();
        }
        this.recordMap.put(key, transactionLogRecord);
    }

    public TransactionLogRecord get(Object key) {
        return this.recordMap.get(key);
    }

    public Collection<TransactionLogRecord> getRecords() {
        return this.recordMap.values();
    }

    public void remove(Object key) {
        this.recordMap.remove(key);
    }

    public int size() {
        return this.recordMap.size();
    }

    public List<Future<Object>> commit(NodeEngine nodeEngine) {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(this.size());
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            Future<Object> future = this.invoke(nodeEngine, transactionLogRecord, transactionLogRecord.newCommitOperation());
            futures.add(future);
        }
        return futures;
    }

    public void onCommitSuccess() {
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            transactionLogRecord.onCommitSuccess();
        }
    }

    public void onCommitFailure() {
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            transactionLogRecord.onCommitFailure();
        }
    }

    public List<Future<Object>> prepare(NodeEngine nodeEngine) {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(this.size());
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            Future<Object> future = this.invoke(nodeEngine, transactionLogRecord, transactionLogRecord.newPrepareOperation());
            futures.add(future);
        }
        return futures;
    }

    public List<Future<Object>> rollback(NodeEngine nodeEngine) {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(this.size());
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            Future<Object> future = this.invoke(nodeEngine, transactionLogRecord, transactionLogRecord.newRollbackOperation());
            futures.add(future);
        }
        return futures;
    }

    private Future<Object> invoke(NodeEngine nodeEngine, TransactionLogRecord transactionLogRecord, Operation op) {
        OperationService operationService = nodeEngine.getOperationService();
        if (transactionLogRecord instanceof TargetAwareTransactionLogRecord) {
            TargetAwareTransactionLogRecord logRecord = (TargetAwareTransactionLogRecord)transactionLogRecord;
            Address target = logRecord.getTarget();
            return operationService.invokeOnTarget(op.getServiceName(), op, target);
        }
        return operationService.invokeOnPartition(op.getServiceName(), op, op.getPartitionId());
    }

    public void commitAsync(NodeEngine nodeEngine, BiConsumer callback) {
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            this.invokeAsync(nodeEngine, callback, transactionLogRecord, transactionLogRecord.newCommitOperation());
        }
    }

    public void rollbackAsync(NodeEngine nodeEngine, BiConsumer callback) {
        for (TransactionLogRecord transactionLogRecord : this.recordMap.values()) {
            this.invokeAsync(nodeEngine, callback, transactionLogRecord, transactionLogRecord.newRollbackOperation());
        }
    }

    private void invokeAsync(NodeEngine nodeEngine, BiConsumer callback, TransactionLogRecord transactionLogRecord, Operation op) {
        OperationServiceImpl operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        if (transactionLogRecord instanceof TargetAwareTransactionLogRecord) {
            TargetAwareTransactionLogRecord logRecord = (TargetAwareTransactionLogRecord)transactionLogRecord;
            Address target = logRecord.getTarget();
            operationService.invokeOnTarget(op.getServiceName(), op, target);
        } else {
            operationService.invokeOnPartitionAsync(op.getServiceName(), op, op.getPartitionId()).whenCompleteAsync(callback, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
    }
}

