/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.RejectionInversionZipfSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DiscreteDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class ZipfDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfElements;
    private final double exponent;
    private final double nthHarmonic;
    private final double logNthHarmonic;

    private ZipfDistribution(int numberOfElements, double exponent) {
        this.numberOfElements = numberOfElements;
        this.exponent = exponent;
        this.nthHarmonic = ZipfDistribution.generalizedHarmonic(numberOfElements, exponent);
        this.logNthHarmonic = Math.log(this.nthHarmonic);
    }

    public static ZipfDistribution of(int numberOfElements, double exponent) {
        if (numberOfElements <= 0) {
            throw new DistributionException("Number %s is not greater than 0", numberOfElements);
        }
        if (exponent < 0.0) {
            throw new DistributionException("Number %s is negative", exponent);
        }
        return new ZipfDistribution(numberOfElements, exponent);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Override
    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return Math.pow(x, -this.exponent) / this.nthHarmonic;
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(x) * this.exponent - this.logNthHarmonic;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return ZipfDistribution.generalizedHarmonic(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double survivalProbability(int x) {
        double hx;
        double hx1;
        if (x <= 0) {
            return 1.0;
        }
        if (x >= this.numberOfElements) {
            return 0.0;
        }
        double z = Math.pow((double)x + 1.0, this.exponent);
        double p = (z * (this.nthHarmonic - (hx1 = (hx = ZipfDistribution.generalizedHarmonic(x, this.exponent)) + Math.pow((double)x + 1.0, -this.exponent))) + 1.0) / (z * this.nthHarmonic);
        return p <= 1.0 ? p : 1.0 - hx / this.nthHarmonic;
    }

    @Override
    public double getMean() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs1 = ZipfDistribution.generalizedHarmonicAscendingSum(N, s - 1.0);
        return Hs1 / this.nthHarmonic;
    }

    @Override
    public double getVariance() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs2 = ZipfDistribution.generalizedHarmonicAscendingSum(N, s - 2.0);
        double Hs1 = ZipfDistribution.generalizedHarmonicAscendingSum(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs2 / Hs - Hs1 * Hs1 / (Hs * Hs);
    }

    private static double generalizedHarmonic(int n, double m) {
        double value = 0.0;
        for (int k = n; k >= 1; --k) {
            value += Math.pow(k, -m);
        }
        return value;
    }

    private static double generalizedHarmonicAscendingSum(int n, double m) {
        double value = 0.0;
        if (m < 0.0) {
            for (int k = 1; k <= n; ++k) {
                value += Math.pow(k, -m);
            }
        } else {
            for (int k = n; k >= 1; --k) {
                value += Math.pow(k, -m);
            }
        }
        return value;
    }

    @Override
    public int getSupportLowerBound() {
        return 1;
    }

    @Override
    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateDiscreteSampler)RejectionInversionZipfSampler.of((UniformRandomProvider)rng, (int)this.numberOfElements, (double)this.exponent)).sample();
    }
}

