/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.RegularizedGamma;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.GaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.PoissonSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.ZigguratSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DiscreteDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.SaddlePointExpansionUtils;

public final class PoissonDistribution
extends AbstractDiscreteDistribution {
    private static final double MAX_MEAN = 1.0737418235E9;
    private final double mean;

    private PoissonDistribution(double mean) {
        this.mean = mean;
    }

    public static PoissonDistribution of(double mean) {
        if (mean <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", mean);
        }
        return new PoissonDistribution(mean);
    }

    @Override
    public double probability(int x) {
        return Math.exp(this.logProbability(x));
    }

    @Override
    public double logProbability(int x) {
        if (x < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0) {
            return -this.mean;
        }
        return -SaddlePointExpansionUtils.getStirlingError(x) - SaddlePointExpansionUtils.getDeviancePart(x, this.mean) - 0.9189385332046728 - 0.5 * Math.log(x);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x == 0) {
            return Math.exp(-this.mean);
        }
        return RegularizedGamma.Q.value((double)x + 1.0, this.mean);
    }

    @Override
    public double survivalProbability(int x) {
        if (x < 0) {
            return 1.0;
        }
        if (x == 0) {
            return -Math.expm1(-this.mean);
        }
        return RegularizedGamma.P.value((double)x + 1.0, this.mean);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.getMean();
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        double mu = this.getMean();
        if (mu < 1.0737418235E9) {
            return () -> ((SharedStateDiscreteSampler)PoissonSampler.of((UniformRandomProvider)rng, (double)mu)).sample();
        }
        SharedStateContinuousSampler s = GaussianSampler.of((NormalizedGaussianSampler)ZigguratSampler.NormalizedGaussian.of((UniformRandomProvider)rng), (double)(mu + 0.5), (double)Math.sqrt(mu));
        return () -> {
            double x = s.sample();
            return Math.max(0, (int)x);
        };
    }
}

