/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Erf;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Erfc;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.InverseErf;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.InverseErfc;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.LevySampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class LevyDistribution
extends AbstractContinuousDistribution {
    private static final double HALF_OVER_ERFCINV_HALF_SQUARED = 2.1981093383177326;
    private final double mu;
    private final double c;
    private final double halfC;

    private LevyDistribution(double mu, double c) {
        this.mu = mu;
        this.c = c;
        this.halfC = 0.5 * c;
    }

    public static LevyDistribution of(double mu, double c) {
        if (c <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", c);
        }
        return new LevyDistribution(mu, c);
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.c;
    }

    @Override
    public double density(double x) {
        if (x <= this.mu) {
            return 0.0;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return Math.sqrt(f / Math.PI) * Math.exp(-f) / delta;
    }

    @Override
    public double logDensity(double x) {
        if (x <= this.mu) {
            return Double.NEGATIVE_INFINITY;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return 0.5 * Math.log(f / Math.PI) - f - Math.log(delta);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.mu) {
            return 0.0;
        }
        return Erfc.value(Math.sqrt(this.halfC / (x - this.mu)));
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= this.mu) {
            return 1.0;
        }
        return Erf.value(Math.sqrt(this.halfC / (x - this.mu)));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        double t = InverseErfc.value(p);
        return this.mu + this.halfC / (t * t);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        double t = InverseErf.value(p);
        return this.mu + this.halfC / (t * t);
    }

    @Override
    public double getMean() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getSupportLowerBound() {
        return this.getLocation();
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    double getMedian() {
        return this.mu + this.c * 2.1981093383177326;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((LevySampler)LevySampler.of((UniformRandomProvider)rng, (double)this.getLocation(), (double)this.getScale())).sample();
    }
}

