/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class GumbelDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = Double.NEGATIVE_INFINITY;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double PI_SQUARED_OVER_SIX = 1.6449340668482264;
    private static final double EULER = 0.5772156649015329;
    private static final double LN_LN_2 = -0.36651292058166435;
    private final double mu;
    private final double beta;

    private GumbelDistribution(double mu, double beta) {
        this.beta = beta;
        this.mu = mu;
    }

    public static GumbelDistribution of(double mu, double beta) {
        if (beta <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", beta);
        }
        return new GumbelDistribution(mu, beta);
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        if (x <= Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double z = (x - this.mu) / this.beta;
        double t = Math.exp(-z);
        return Math.exp(-z - t) / this.beta;
    }

    @Override
    public double logDensity(double x) {
        if (x <= Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double z = (x - this.mu) / this.beta;
        double t = Math.exp(-z);
        return -z - t - Math.log(this.beta);
    }

    @Override
    public double cumulativeProbability(double x) {
        double z = (x - this.mu) / this.beta;
        return Math.exp(-Math.exp(-z));
    }

    @Override
    public double survivalProbability(double x) {
        double z = (x - this.mu) / this.beta;
        return -Math.expm1(-Math.exp(-z));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu - Math.log(-Math.log(p)) * this.beta;
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu - Math.log(-Math.log1p(-p)) * this.beta;
    }

    @Override
    public double getMean() {
        return this.mu + 0.5772156649015329 * this.beta;
    }

    @Override
    public double getVariance() {
        return 1.6449340668482264 * this.beta * this.beta;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    double getMedian() {
        return this.mu - this.beta * -0.36651292058166435;
    }
}

