/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.LogBeta;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.RegularizedBeta;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class FDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double MIN_DENOMINATOR_DF_FOR_MEAN = 2.0;
    private static final double MIN_DENOMINATOR_DF_FOR_VARIANCE = 4.0;
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;
    private final double nHalfLogNmHalfLogM;
    private final double logBetaNhalfMhalf;
    private final double mean;
    private final double variance;

    private FDistribution(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        this.numeratorDegreesOfFreedom = numeratorDegreesOfFreedom;
        this.denominatorDegreesOfFreedom = denominatorDegreesOfFreedom;
        double nhalf = numeratorDegreesOfFreedom / 2.0;
        double mhalf = denominatorDegreesOfFreedom / 2.0;
        this.nHalfLogNmHalfLogM = nhalf * Math.log(numeratorDegreesOfFreedom) + mhalf * Math.log(denominatorDegreesOfFreedom);
        this.logBetaNhalfMhalf = LogBeta.value(nhalf, mhalf);
        this.mean = denominatorDegreesOfFreedom > 2.0 ? denominatorDegreesOfFreedom / (denominatorDegreesOfFreedom - 2.0) : Double.NaN;
        if (denominatorDegreesOfFreedom > 4.0) {
            double denomDFMinusTwo = denominatorDegreesOfFreedom - 2.0;
            this.variance = 2.0 * (denominatorDegreesOfFreedom * denominatorDegreesOfFreedom) * (numeratorDegreesOfFreedom + denominatorDegreesOfFreedom - 2.0) / (numeratorDegreesOfFreedom * (denomDFMinusTwo * denomDFMinusTwo) * (denominatorDegreesOfFreedom - 4.0));
        } else {
            this.variance = Double.NaN;
        }
    }

    public static FDistribution of(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        if (numeratorDegreesOfFreedom <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", numeratorDegreesOfFreedom);
        }
        if (denominatorDegreesOfFreedom <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", denominatorDegreesOfFreedom);
        }
        return new FDistribution(numeratorDegreesOfFreedom, denominatorDegreesOfFreedom);
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            if (x == 0.0 && this.numeratorDegreesOfFreedom <= 2.0) {
                return this.numeratorDegreesOfFreedom == 2.0 ? 1.0 : Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        return this.computeDensity(x, false);
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            if (x == 0.0 && this.numeratorDegreesOfFreedom <= 2.0) {
                return this.numeratorDegreesOfFreedom == 2.0 ? 0.0 : Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return this.computeDensity(x, true);
    }

    private double computeDensity(double x, boolean log) {
        double n = this.numeratorDegreesOfFreedom;
        double m = this.denominatorDegreesOfFreedom;
        double nx = n * x;
        double z = m + nx;
        double y = n * m / (z * z);
        double p = nx > m ? y * RegularizedBeta.derivative(m / z, m / 2.0, n / 2.0) : y * RegularizedBeta.derivative(nx / z, n / 2.0, m / 2.0);
        if (p <= Double.MAX_VALUE && p >= Double.MIN_NORMAL) {
            return log ? Math.log(p) : p;
        }
        p = this.nHalfLogNmHalfLogM + (n / 2.0 - 1.0) * Math.log(x) - this.logBetaNhalfMhalf - (n + m) / 2.0 * Math.log(z);
        return log ? p : Math.exp(p);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        double n = this.numeratorDegreesOfFreedom;
        double nx = n * x;
        double m = this.denominatorDegreesOfFreedom;
        if (nx > m) {
            return RegularizedBeta.complement(m / (m + nx), m / 2.0, n / 2.0);
        }
        return RegularizedBeta.value(nx / (m + nx), n / 2.0, m / 2.0);
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double n = this.numeratorDegreesOfFreedom;
        double nx = n * x;
        double m = this.denominatorDegreesOfFreedom;
        if (nx > m) {
            return RegularizedBeta.value(m / (m + nx), m / 2.0, n / 2.0);
        }
        return RegularizedBeta.complement(nx / (m + nx), n / 2.0, m / 2.0);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }
}

