/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.StableSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class CauchyDistribution
extends AbstractContinuousDistribution {
    private final double location;
    private final double scale;
    private final double scaleOverPi;
    private final double scale2;

    private CauchyDistribution(double location, double scale) {
        this.scale = scale;
        this.location = location;
        this.scaleOverPi = scale / Math.PI;
        this.scale2 = scale * scale;
    }

    public static CauchyDistribution of(double location, double scale) {
        if (scale <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", scale);
        }
        return new CauchyDistribution(location, scale);
    }

    public double getLocation() {
        return this.location;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        double dev = x - this.location;
        return this.scaleOverPi / (dev * dev + this.scale2);
    }

    @Override
    public double cumulativeProbability(double x) {
        return CauchyDistribution.cdf((x - this.location) / this.scale);
    }

    @Override
    public double survivalProbability(double x) {
        return CauchyDistribution.cdf(-(x - this.location) / this.scale);
    }

    private static double cdf(double x) {
        return 0.5 + Math.atan(x) / Math.PI;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.location + this.scale * Math.tan(Math.PI * (p - 0.5));
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.location - this.scale * Math.tan(Math.PI * (p - 0.5));
    }

    @Override
    public double getMean() {
        return Double.NaN;
    }

    @Override
    public double getVariance() {
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    double getMedian() {
        return this.location;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((StableSampler)StableSampler.of((UniformRandomProvider)rng, (double)1.0, (double)0.0, (double)this.getScale(), (double)this.getLocation())).sample();
    }
}

