/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DiscreteDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;
import java.util.function.IntUnaryOperator;

abstract class AbstractDiscreteDistribution
implements DiscreteDistribution {
    private static final long NO_MEDIAN = Long.MIN_VALUE;
    private long median = Long.MIN_VALUE;

    AbstractDiscreteDistribution() {
    }

    int getMedian() {
        long m = this.median;
        if (m == Long.MIN_VALUE) {
            this.median = m = (long)this.inverseCumulativeProbability(0.5);
        }
        return (int)m;
    }

    @Override
    public double probability(int x0, int x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        if ((long)x0 + 1L >= (long)x1) {
            return x0 == x1 ? 0.0 : this.probability(x1);
        }
        double m = this.getMedian();
        if ((double)x0 >= m) {
            return this.survivalProbability(x0) - this.survivalProbability(x1);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public int inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.inverseProbability(p, 1.0 - p, false);
    }

    @Override
    public int inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.inverseProbability(1.0 - p, p, true);
    }

    private int inverseProbability(double p, double q, boolean complement) {
        boolean chebyshevApplies;
        IntUnaryOperator fun;
        int lower = this.getSupportLowerBound();
        if (p == 0.0) {
            return lower;
        }
        int upper = this.getSupportUpperBound();
        if (q == 0.0) {
            return upper;
        }
        IntUnaryOperator intUnaryOperator = fun = complement ? x -> Double.compare(q, this.survivalProbability(x)) : x -> Double.compare(this.cumulativeProbability(x), p);
        if (lower == Integer.MIN_VALUE) {
            if (fun.applyAsInt(lower) >= 0) {
                return lower;
            }
        } else {
            --lower;
        }
        double mu = this.getMean();
        double sig = Math.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = Double.isFinite(mu) && ArgumentUtils.isFiniteStrictlyPositive(sig);
        if (chebyshevApplies) {
            double tmp = mu - sig * Math.sqrt(q / p);
            if (tmp > (double)lower) {
                lower = (int)Math.ceil(tmp) - 1;
            }
            if ((tmp = mu + sig * Math.sqrt(p / q)) < (double)upper) {
                upper = (int)Math.ceil(tmp) - 1;
            }
        }
        return AbstractDiscreteDistribution.solveInverseProbability(fun, lower, upper);
    }

    private static int solveInverseProbability(IntUnaryOperator fun, int lowerBound, int upperBound) {
        long lower = lowerBound;
        long upper = upperBound;
        while (lower + 1L < upper) {
            long middle = (lower + upper) / 2L;
            int pm = fun.applyAsInt((int)middle);
            if (pm < 0) {
                lower = middle;
                continue;
            }
            upper = middle;
        }
        return (int)upper;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateDiscreteSampler)InverseTransformDiscreteSampler.of((UniformRandomProvider)rng, this::inverseCumulativeProbability)).sample();
    }
}

