/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.numbers.gamma;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.GammaException;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.LogGamma1p;

final class LogGammaSum {
    private LogGammaSum() {
    }

    static double value(double a2, double b) {
        if (a2 < 1.0 || a2 > 2.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", a2, 1, 2);
        }
        if (b < 1.0 || b > 2.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", b, 1, 2);
        }
        double x = a2 - 1.0 + (b - 1.0);
        if (x <= 0.5) {
            return LogGamma1p.value(1.0 + x);
        }
        if (x <= 1.5) {
            return LogGamma1p.value(x) + Math.log1p(x);
        }
        return LogGamma1p.value(x - 1.0) + Math.log(x * (1.0 + x));
    }
}

