/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.numbers.fraction;

import com.hazelcast.shaded.org.apache.commons.numbers.fraction.GeneralizedContinuedFraction;
import java.util.function.Supplier;

public abstract class ContinuedFraction {
    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double x, double epsilon) {
        return this.evaluate(x, epsilon, Integer.MAX_VALUE);
    }

    public double evaluate(final double x, double epsilon, int maxIterations) {
        double b0 = this.getB(0, x);
        Supplier<GeneralizedContinuedFraction.Coefficient> gen = new Supplier<GeneralizedContinuedFraction.Coefficient>(){
            private int n;

            @Override
            public GeneralizedContinuedFraction.Coefficient get() {
                ++this.n;
                double a2 = ContinuedFraction.this.getA(this.n, x);
                double b = ContinuedFraction.this.getB(this.n, x);
                return GeneralizedContinuedFraction.Coefficient.of(a2, b);
            }
        };
        if (Math.abs(b0) < 1.0E-50) {
            return GeneralizedContinuedFraction.value(b0, gen, epsilon, maxIterations);
        }
        return GeneralizedContinuedFraction.evaluate(b0, gen, epsilon, maxIterations);
    }
}

