/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona.concurrent;

import com.hazelcast.shaded.org.agrona.concurrent.SigInt;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public class ShutdownSignalBarrier {
    public static final String[] SIGNAL_NAMES = new String[]{"INT", "TERM"};
    private static final ArrayList<CountDownLatch> LATCHES = new ArrayList();
    private final CountDownLatch latch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownSignalBarrier() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.add(this.latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.remove(this.latch);
            this.latch.countDown();
        }
    }

    public void signalAll() {
        ShutdownSignalBarrier.signalAndClearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.remove(this.latch);
        }
    }

    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void signalAndClearAll() {
        ArrayList<CountDownLatch> arrayList = LATCHES;
        synchronized (arrayList) {
            LATCHES.forEach(CountDownLatch::countDown);
            LATCHES.clear();
        }
    }

    static {
        for (String signalName : SIGNAL_NAMES) {
            SigInt.register(signalName, ShutdownSignalBarrier::signalAndClearAll);
        }
    }
}

