/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.util;

import com.hazelcast.shaded.io.github.jbellis.jvector.util.BitSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ThreadSafeGrowableBitSet
extends BitSet {
    private final java.util.BitSet bitSet;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ThreadSafeGrowableBitSet(java.util.BitSet bitSet) {
        this.bitSet = bitSet;
    }

    public ThreadSafeGrowableBitSet(int initialBits) {
        this.bitSet = new java.util.BitSet(initialBits);
    }

    @Override
    public void clear(int index) {
        this.lock.writeLock().lock();
        try {
            this.bitSet.clear(index);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.bitSet.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean get(int index) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.bitSet.get(index);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAndSet(int index) {
        this.lock.writeLock().lock();
        try {
            boolean v = this.get(index);
            this.set(index);
            boolean bl = v;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int length() {
        this.lock.readLock().lock();
        try {
            int n = this.bitSet.length();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void set(int i) {
        this.lock.writeLock().lock();
        try {
            this.bitSet.set(i);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        this.lock.writeLock().lock();
        try {
            if (startIndex == 0 && endIndex == this.bitSet.length()) {
                this.bitSet.clear();
                return;
            }
            if (startIndex >= endIndex) {
                return;
            }
            this.bitSet.clear(startIndex, endIndex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int cardinality() {
        this.lock.readLock().lock();
        try {
            int n = this.bitSet.cardinality();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int approximateCardinality() {
        this.lock.readLock().lock();
        try {
            int n = this.bitSet.cardinality();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int prevSetBit(int index) {
        this.lock.readLock().lock();
        try {
            int n = this.bitSet.previousSetBit(index);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextSetBit(int i) {
        this.lock.readLock().lock();
        try {
            int next = this.bitSet.nextSetBit(i);
            if (next == -1) {
                next = Integer.MAX_VALUE;
            }
            int n = next;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        throw new UnsupportedOperationException();
    }

    public ThreadSafeGrowableBitSet copy() {
        this.lock.readLock().lock();
        try {
            ThreadSafeGrowableBitSet threadSafeGrowableBitSet = new ThreadSafeGrowableBitSet((java.util.BitSet)this.bitSet.clone());
            return threadSafeGrowableBitSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

