/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.util;

import com.hazelcast.shaded.io.github.jbellis.jvector.annotations.VisibleForTesting;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.ArrayUtil;

public abstract class AbstractLongHeap {
    protected long[] heap;
    protected int size = 0;

    public AbstractLongHeap(int initialSize) {
        if (initialSize < 1 || initialSize >= ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("initialSize must be > 0 and < " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + initialSize);
        }
        int heapSize = initialSize + 1;
        this.heap = new long[heapSize];
    }

    public abstract boolean push(long var1);

    protected long add(long element) {
        ++this.size;
        if (this.size == this.heap.length) {
            this.heap = ArrayUtil.grow(this.heap, (this.size * 3 + 1) / 2);
        }
        this.heap[this.size] = element;
        this.upHeap(this.size);
        return this.heap[1];
    }

    public final long top() {
        return this.heap[1];
    }

    public final long pop() {
        if (this.size > 0) {
            long result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            this.downHeap(1);
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.size = 0;
    }

    protected void upHeap(int origPos) {
        int i = origPos;
        long value = this.heap[i];
        for (int j = i >>> 1; j > 0 && value < this.heap[j]; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = value;
    }

    protected void downHeap(int i) {
        long value = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k] < this.heap[j]) {
            j = k;
        }
        while (j <= this.size && this.heap[j] < value) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || this.heap[k] >= this.heap[j]) continue;
            j = k;
        }
        this.heap[i] = value;
    }

    public long get(int i) {
        return this.heap[i];
    }

    @VisibleForTesting
    long[] getHeapArray() {
        return this.heap;
    }
}

