/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.pq;

import com.hazelcast.shaded.io.github.jbellis.jvector.pq.MutableCompressedVectors;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.PQVectors;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.ProductQuantization;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorizationProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.ByteSequence;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorTypeSupport;

public class MutablePQVectors
extends PQVectors
implements MutableCompressedVectors<VectorFloat<?>> {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private static final int VECTORS_PER_CHUNK = 1024;
    private static final int INITIAL_CHUNKS = 10;
    private static final float GROWTH_FACTOR = 1.5f;

    public MutablePQVectors(ProductQuantization pq) {
        super(pq);
        this.vectorCount = 0;
        this.vectorsPerChunk = 1024;
        this.compressedDataChunks = new ByteSequence[10];
    }

    @Override
    public void encodeAndSet(int ordinal, VectorFloat<?> vector) {
        this.ensureChunkCapacity(ordinal);
        this.vectorCount = Math.max(this.vectorCount, ordinal + 1);
        this.pq.encodeTo(vector, this.get(ordinal));
    }

    @Override
    public void setZero(int ordinal) {
        this.ensureChunkCapacity(ordinal);
        this.vectorCount = Math.max(this.vectorCount, ordinal + 1);
        this.get(ordinal).zero();
    }

    private void ensureChunkCapacity(int ordinal) {
        int chunkOrdinal = ordinal / this.vectorsPerChunk;
        if (chunkOrdinal >= this.compressedDataChunks.length) {
            int newLength = Math.max(chunkOrdinal + 1, (int)((float)this.compressedDataChunks.length * 1.5f));
            ByteSequence[] newChunks = new ByteSequence[newLength];
            System.arraycopy(this.compressedDataChunks, 0, newChunks, 0, this.compressedDataChunks.length);
            this.compressedDataChunks = newChunks;
        }
        int chunkBytes = 1024 * this.pq.compressedVectorSize();
        for (int i = this.validChunkCount(); i <= chunkOrdinal; ++i) {
            if (this.compressedDataChunks[i] != null) continue;
            this.compressedDataChunks[i] = vectorTypeSupport.createByteSequence(chunkBytes);
        }
    }

    @Override
    protected int validChunkCount() {
        if (this.vectorCount == 0) {
            return 0;
        }
        int chunkOrdinal = (this.vectorCount - 1) / this.vectorsPerChunk;
        return chunkOrdinal + 1;
    }
}

