/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.pq;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.BinaryQuantization;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.CompressedVectors;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.ImmutableBQVectors;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorUtil;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public abstract class BQVectors
implements CompressedVectors {
    protected final BinaryQuantization bq;
    protected long[][] compressedVectors;
    protected int vectorCount;

    protected BQVectors(BinaryQuantization bq) {
        this.bq = bq;
    }

    @Override
    public int count() {
        return this.vectorCount;
    }

    @Override
    public void write(DataOutput out, int version) throws IOException {
        this.bq.write(out, version);
        out.writeInt(this.compressedVectors.length);
        if (this.compressedVectors.length <= 0) {
            return;
        }
        out.writeInt(this.compressedVectors[0].length);
        long[][] lArray = this.compressedVectors;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] v;
            for (long l : v = lArray[i]) {
                out.writeLong(l);
            }
        }
    }

    public static BQVectors load(RandomAccessReader in, long offset) throws IOException {
        in.seek(offset);
        BinaryQuantization bq = BinaryQuantization.load(in);
        int size = in.readInt();
        if (size < 0) {
            throw new IOException("Invalid compressed vector count " + size);
        }
        long[][] compressedVectors = new long[size][];
        if (size == 0) {
            return new ImmutableBQVectors(bq, compressedVectors);
        }
        int compressedLength = in.readInt();
        if (compressedLength < 0) {
            throw new IOException("Invalid compressed vector dimension " + compressedLength);
        }
        for (int i = 0; i < size; ++i) {
            long[] vector = new long[compressedLength];
            in.readFully(vector);
            compressedVectors[i] = vector;
        }
        return new ImmutableBQVectors(bq, compressedVectors);
    }

    @Override
    public ScoreFunction.ApproximateScoreFunction precomputedScoreFunctionFor(VectorFloat<?> q, VectorSimilarityFunction similarityFunction) {
        return this.scoreFunctionFor(q, similarityFunction);
    }

    @Override
    public ScoreFunction.ApproximateScoreFunction scoreFunctionFor(VectorFloat<?> q, VectorSimilarityFunction similarityFunction) {
        long[] qBQ = this.bq.encode(q);
        return node2 -> {
            long[] vBQ = this.compressedVectors[node2];
            return this.similarityBetween(qBQ, vBQ);
        };
    }

    public float similarityBetween(long[] encoded1, long[] encoded2) {
        return 1.0f - (float)VectorUtil.hammingDistance(encoded1, encoded2) / (float)this.bq.getOriginalDimension();
    }

    public long[] get(int i) {
        return this.compressedVectors[i];
    }

    @Override
    public int getOriginalSize() {
        return this.bq.getOriginalDimension() * 4;
    }

    @Override
    public int getCompressedSize() {
        return this.compressedVectors[0].length * 8;
    }

    public BinaryQuantization getCompressor() {
        return this.bq;
    }

    @Override
    public long ramBytesUsed() {
        return (long)this.compressedVectors.length * RamUsageEstimator.sizeOf(this.compressedVectors[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BQVectors bqVectors = (BQVectors)o;
        return Objects.equals(this.bq, bqVectors.bq) && Arrays.deepEquals((Object[])this.compressedVectors, (Object[])bqVectors.compressedVectors);
    }

    public int hashCode() {
        int result = Objects.hash(this.bq);
        result = 31 * result + Arrays.deepHashCode((Object[])this.compressedVectors);
        return result;
    }

    public String toString() {
        return "BQVectors{bq=" + String.valueOf(this.bq) + ", count=" + this.compressedVectors.length + "}";
    }
}

