/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.CommonHeader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.Feature;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.FeatureId;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorizationProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.DataOutput;
import java.io.IOException;

public class InlineVectors
implements Feature {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private final int dimension;

    public InlineVectors(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public FeatureId id() {
        return FeatureId.INLINE_VECTORS;
    }

    @Override
    public int headerSize() {
        return 0;
    }

    @Override
    public int inlineSize() {
        return this.dimension * 4;
    }

    public int dimension() {
        return this.dimension;
    }

    static InlineVectors load(CommonHeader header, RandomAccessReader reader) {
        return new InlineVectors(header.dimension);
    }

    @Override
    public void writeHeader(DataOutput out) {
    }

    @Override
    public void writeInline(DataOutput out, Feature.State state) throws IOException {
        vectorTypeSupport.writeFloatVector(out, ((State)state).vector);
    }

    public static class State
    implements Feature.State {
        public final VectorFloat<?> vector;

        public State(VectorFloat<?> vector) {
            this.vector = vector;
        }
    }
}

