/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodesIterator;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.OnDiskGraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Accountable;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.org.agrona.collections.Int2ObjectHashMap;

public abstract class GraphCache
implements Accountable {
    public abstract CachedNode getNode(int var1);

    public static GraphCache load(OnDiskGraphIndex graph, int distance) {
        if (distance < 0) {
            return new EmptyGraphCache();
        }
        return new HMGraphCache(graph, distance);
    }

    @Override
    public abstract long ramBytesUsed();

    private static final class EmptyGraphCache
    extends GraphCache {
        private EmptyGraphCache() {
        }

        @Override
        public CachedNode getNode(int ordinal) {
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }
    }

    private static final class HMGraphCache
    extends GraphCache {
        private final Int2ObjectHashMap<CachedNode> cache;
        private long ramBytesUsed = 0L;

        public HMGraphCache(OnDiskGraphIndex graph, int distance) {
            try (OnDiskGraphIndex.View view = graph.getView();){
                Int2ObjectHashMap<CachedNode> tmpCache = new Int2ObjectHashMap<CachedNode>();
                this.cacheNeighborsOf(tmpCache, view, view.entryNode(), distance);
                this.cache = tmpCache;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void cacheNeighborsOf(Int2ObjectHashMap<CachedNode> tmpCache, OnDiskGraphIndex.View view, int ordinal, int distance) {
            NodesIterator it = view.getNeighborsIterator(ordinal);
            int[] neighbors = new int[it.size()];
            int i = 0;
            while (it.hasNext()) {
                neighbors[i++] = it.nextInt();
            }
            CachedNode node = new CachedNode(neighbors);
            tmpCache.put(ordinal, node);
            this.ramBytesUsed += (long)(4 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + node.ramBytesUsed();
            if (distance > 0) {
                for (int neighbor : neighbors) {
                    if (tmpCache.containsKey(neighbor)) continue;
                    this.cacheNeighborsOf(tmpCache, view, neighbor, distance - 1);
                }
            }
        }

        @Override
        public CachedNode getNode(int ordinal) {
            return this.cache.get(ordinal);
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }

    public static class CachedNode
    implements Accountable {
        public final int[] neighbors;

        public CachedNode(int[] neighbors) {
            this.neighbors = neighbors;
        }

        @Override
        public long ramBytesUsed() {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.neighbors.length * 4L;
        }
    }
}

