/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.annotations.VisibleForTesting;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.ArrayUtil;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.org.agrona.collections.IntHashSet;
import java.util.Arrays;

public class NodeArray {
    public static final NodeArray EMPTY = new NodeArray(0);
    private int size;
    private float[] scores;
    private int[] nodes;

    public NodeArray(int initialSize) {
        this.nodes = new int[initialSize];
        this.scores = new float[initialSize];
    }

    protected NodeArray(NodeArray nodeArray) {
        this.size = nodeArray.size();
        this.nodes = nodeArray.nodes;
        this.scores = nodeArray.scores;
    }

    static NodeArray merge(NodeArray a1, NodeArray a2) {
        NodeArray merged = new NodeArray(a1.size() + a2.size());
        int i = 0;
        int j = 0;
        IntHashSet nodesWithLastScore = new IntHashSet();
        float lastAddedScore = Float.NaN;
        while (i < a1.size() && j < a2.size()) {
            if (a1.scores[i] < a2.scores[j]) {
                if (a2.scores[j] != lastAddedScore) {
                    nodesWithLastScore.clear();
                    lastAddedScore = a2.scores[j];
                }
                if (nodesWithLastScore.add(a2.nodes[j])) {
                    merged.addInOrder(a2.nodes[j], a2.scores[j]);
                }
                ++j;
                continue;
            }
            if (a1.scores[i] > a2.scores[j]) {
                if (a1.scores[i] != lastAddedScore) {
                    nodesWithLastScore.clear();
                    lastAddedScore = a1.scores[i];
                }
                if (nodesWithLastScore.add(a1.nodes[i])) {
                    merged.addInOrder(a1.nodes[i], a1.scores[i]);
                }
                ++i;
                continue;
            }
            if (a1.scores[i] != lastAddedScore) {
                nodesWithLastScore.clear();
                lastAddedScore = a1.scores[i];
            }
            if (nodesWithLastScore.add(a1.nodes[i])) {
                merged.addInOrder(a1.nodes[i], a1.scores[i]);
            }
            if (nodesWithLastScore.add(a2.nodes[j])) {
                merged.addInOrder(a2.nodes[j], a2.scores[j]);
            }
            ++i;
            ++j;
        }
        if (i < a1.size()) {
            while (i < a1.size && a1.scores[i] == lastAddedScore) {
                if (!nodesWithLastScore.contains(a1.nodes[i])) {
                    merged.addInOrder(a1.nodes[i], a1.scores[i]);
                }
                ++i;
            }
            System.arraycopy(a1.nodes, i, merged.nodes, merged.size, a1.size - i);
            System.arraycopy(a1.scores, i, merged.scores, merged.size, a1.size - i);
            merged.size += a1.size - i;
        }
        if (j < a2.size()) {
            while (j < a2.size && a2.scores[j] == lastAddedScore) {
                if (!nodesWithLastScore.contains(a2.nodes[j])) {
                    merged.addInOrder(a2.nodes[j], a2.scores[j]);
                }
                ++j;
            }
            System.arraycopy(a2.nodes, j, merged.nodes, merged.size, a2.size - j);
            System.arraycopy(a2.scores, j, merged.scores, merged.size, a2.size - j);
            merged.size += a2.size - j;
        }
        return merged;
    }

    public void addInOrder(int newNode, float newScore) {
        if (this.size == this.nodes.length) {
            this.growArrays();
        }
        if (this.size > 0) {
            float previousScore = this.scores[this.size - 1];
            assert (previousScore >= newScore) : "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.toString(ArrayUtil.copyOfSubArray(this.scores, 0, this.size));
        }
        this.nodes[this.size] = newNode;
        this.scores[this.size] = newScore;
        ++this.size;
    }

    public int insertSorted(int newNode, float newScore) {
        int insertionPoint;
        if (this.size == this.nodes.length) {
            this.growArrays();
        }
        if (this.duplicateExistsNear(insertionPoint = this.descSortFindRightMostInsertionPoint(newScore), newNode, newScore)) {
            return -1;
        }
        System.arraycopy(this.nodes, insertionPoint, this.nodes, insertionPoint + 1, this.size - insertionPoint);
        System.arraycopy(this.scores, insertionPoint, this.scores, insertionPoint + 1, this.size - insertionPoint);
        this.nodes[insertionPoint] = newNode;
        this.scores[insertionPoint] = newScore;
        ++this.size;
        return insertionPoint;
    }

    private boolean duplicateExistsNear(int insertionPoint, int newNode, float newScore) {
        int i;
        for (i = insertionPoint - 1; i >= 0 && this.scores[i] == newScore; --i) {
            if (this.nodes[i] != newNode) continue;
            return true;
        }
        for (i = insertionPoint; i < this.size && this.scores[i] == newScore; ++i) {
            if (this.nodes[i] != newNode) continue;
            return true;
        }
        return false;
    }

    public void retain(Bits selected) {
        int writeIdx = 0;
        for (int readIdx = 0; readIdx < this.size; ++readIdx) {
            if (!selected.get(readIdx)) continue;
            if (writeIdx != readIdx) {
                this.nodes[writeIdx] = this.nodes[readIdx];
                this.scores[writeIdx] = this.scores[readIdx];
            }
            ++writeIdx;
        }
        this.size = writeIdx;
    }

    public NodeArray copy() {
        return this.copy(this.size);
    }

    public NodeArray copy(int newSize) {
        if (this.size > newSize) {
            throw new IllegalArgumentException("Cannot copy to a smaller size");
        }
        NodeArray copy = new NodeArray(newSize);
        copy.size = this.size;
        System.arraycopy(this.nodes, 0, copy.nodes, 0, this.size);
        System.arraycopy(this.scores, 0, copy.scores, 0, this.size);
        return copy;
    }

    protected final void growArrays() {
        this.nodes = ArrayUtil.grow(this.nodes);
        this.scores = ArrayUtil.growExact(this.scores, this.nodes.length);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        --this.size;
    }

    public void removeIndex(int idx) {
        System.arraycopy(this.nodes, idx + 1, this.nodes, idx, this.size - idx - 1);
        System.arraycopy(this.scores, idx + 1, this.scores, idx, this.size - idx - 1);
        --this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodeArray(");
        sb.append(this.size).append("/").append(this.nodes.length).append(") [");
        for (int i = 0; i < this.size; ++i) {
            sb.append("(").append(this.nodes[i]).append(",").append(this.scores[i]).append(")").append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected final int descSortFindRightMostInsertionPoint(float newScore) {
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.scores[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    public static long ramBytesUsed(int size) {
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        int AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        return (long)(OH_BYTES + 4 + REF_BYTES + AH_BYTES + REF_BYTES + AH_BYTES) + (long)size * 8L;
    }

    @VisibleForTesting
    boolean contains(int node) {
        for (int i = 0; i < this.size; ++i) {
            if (this.nodes[i] != node) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int[] copyDenseNodes() {
        return Arrays.copyOf(this.nodes, this.size);
    }

    @VisibleForTesting
    float[] copyDenseScores() {
        return Arrays.copyOf(this.scores, this.size);
    }

    protected int insertOrReplaceWorst(int newNode, float newScore) {
        this.size = Math.min(this.size, this.nodes.length - 1);
        return this.insertSorted(newNode, newScore);
    }

    public float getScore(int i) {
        return this.scores[i];
    }

    public int getNode(int i) {
        return this.nodes[i];
    }

    protected int getArrayLength() {
        return this.nodes.length;
    }
}

