/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.ctc.wstx.io;

import com.hazelcast.shaded.com.ctc.wstx.util.XmlChars;
import java.util.stream.IntStream;

public class WstxInputData {
    public static final char CHAR_NULL = '\u0000';
    public static final char INT_NULL = '\u0000';
    public static final char CHAR_SPACE = ' ';
    public static final char INT_SPACE = ' ';
    public static final int MAX_UNICODE_CHAR = 0x10FFFF;
    private static final boolean[] ASCII_NAME_START_CHARS = new boolean[128];
    private static final boolean[] ASCII_NAME_CHARS;
    protected boolean mXml11 = false;
    protected char[] mInputBuffer;
    protected int mInputPtr = 0;
    protected int mInputEnd = 0;
    protected long mCurrInputProcessed = 0L;
    protected int mCurrInputRow = 1;
    protected int mCurrInputRowStart = 0;

    protected WstxInputData() {
    }

    public void copyBufferStateFrom(WstxInputData src) {
        this.mInputBuffer = src.mInputBuffer;
        this.mInputPtr = src.mInputPtr;
        this.mInputEnd = src.mInputEnd;
        this.mCurrInputProcessed = src.mCurrInputProcessed;
        this.mCurrInputRow = src.mCurrInputRow;
        this.mCurrInputRowStart = src.mCurrInputRowStart;
    }

    protected final boolean isNameStartChar(char c) {
        if (c < '\u0080') {
            return ASCII_NAME_START_CHARS[c];
        }
        return this.mXml11 ? XmlChars.is11NameStartChar(c) : XmlChars.is10NameStartChar(c);
    }

    protected final boolean isNameChar(char c) {
        if (c < '\u0080') {
            return ASCII_NAME_CHARS[c];
        }
        return this.mXml11 ? XmlChars.is11NameChar(c) : XmlChars.is10NameChar(c);
    }

    public static final boolean isNameStartChar(char c, boolean nsAware, boolean xml11) {
        if (c <= 'z') {
            if (c >= 'a') {
                return true;
            }
            if (c < 'A') {
                return c == ':' && !nsAware;
            }
            return c <= 'Z' || c == '_';
        }
        return xml11 ? XmlChars.is11NameStartChar(c) : XmlChars.is10NameStartChar(c);
    }

    public static final boolean isNameChar(char c, boolean nsAware, boolean xml11) {
        if (c <= 'z') {
            if (c >= 'a') {
                return true;
            }
            if (c <= 'Z') {
                if (c >= 'A') {
                    return true;
                }
                return c >= '0' && c <= '9' || c == '.' || c == '-' || c == ':' && !nsAware;
            }
            return c == '_';
        }
        return xml11 ? XmlChars.is11NameChar(c) : XmlChars.is10NameChar(c);
    }

    public static final int findIllegalNameChar(String name, boolean nsAware, boolean xml11) {
        int len = name.length();
        if (len < 1) {
            return -1;
        }
        char c = name.charAt(0);
        if (c <= 'z' ? c < 'a' && (c < 'A' ? c != ':' || nsAware : c > 'Z' && c != '_') : (xml11 ? !XmlChars.is11NameStartChar(c) : !XmlChars.is10NameStartChar(c))) {
            return 0;
        }
        for (int i = 1; i < len; ++i) {
            c = name.charAt(i);
            if (c <= 'z' ? c >= 'a' || (c <= 'Z' ? c >= 'A' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == ':' && !nsAware : c == '_') : (xml11 ? XmlChars.is11NameChar(c) : XmlChars.is10NameChar(c))) continue;
            return i;
        }
        return -1;
    }

    public static final int findIllegalNmtokenChar(String nmtoken, boolean nsAware, boolean xml11) {
        int len = nmtoken.length();
        for (int i = 1; i < len; ++i) {
            char c = nmtoken.charAt(i);
            if (c <= 'z' ? c >= 'a' || (c <= 'Z' ? c >= 'A' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == ':' && !nsAware : c == '_') : (xml11 ? XmlChars.is11NameChar(c) : XmlChars.is10NameChar(c))) continue;
            return i;
        }
        return -1;
    }

    public static final boolean isSpaceChar(char c) {
        return c <= ' ';
    }

    public static String getCharDesc(char c) {
        char i = c;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + i + ")";
        }
        if (i > '\u00ff') {
            return "'" + c + "' (code " + i + " / 0x" + Integer.toHexString(i) + ")";
        }
        return "'" + c + "' (code " + i + ")";
    }

    static {
        IntStream.rangeClosed(97, 122).forEach(i -> {
            WstxInputData.ASCII_NAME_START_CHARS[i] = true;
        });
        IntStream.rangeClosed(65, 90).forEach(i -> {
            WstxInputData.ASCII_NAME_START_CHARS[i] = true;
        });
        WstxInputData.ASCII_NAME_START_CHARS[95] = true;
        ASCII_NAME_CHARS = new boolean[128];
        IntStream.rangeClosed(97, 122).forEach(i -> {
            WstxInputData.ASCII_NAME_CHARS[i] = true;
        });
        IntStream.rangeClosed(65, 90).forEach(i -> {
            WstxInputData.ASCII_NAME_CHARS[i] = true;
        });
        IntStream.rangeClosed(48, 57).forEach(i -> {
            WstxInputData.ASCII_NAME_CHARS[i] = true;
        });
        WstxInputData.ASCII_NAME_CHARS[46] = true;
        WstxInputData.ASCII_NAME_CHARS[45] = true;
        WstxInputData.ASCII_NAME_CHARS[95] = true;
    }
}

