/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.security.impl.WeakSecretError;
import java.util.EnumSet;

public final class WeakSecretException
extends HazelcastException {
    @Deprecated(since="5.6", forRemoval=true)
    public static final boolean ENFORCED = Boolean.parseBoolean(System.getProperty("hazelcast.security.secret.strength.policy.enforced", "false"));
    private static final String LINE_SEP = System.lineSeparator();
    private final EnumSet<WeakSecretError> weaknesses;

    private WeakSecretException(EnumSet<WeakSecretError> weaknesses, String details) {
        super(details);
        this.weaknesses = weaknesses;
    }

    public WeakSecretException(String message) {
        super(message);
        this.weaknesses = null;
    }

    public EnumSet<WeakSecretError> getWeaknesses() {
        return this.weaknesses;
    }

    public static WeakSecretException of(String label, EnumSet<WeakSecretError> weaknesses) {
        return new WeakSecretException(weaknesses, WeakSecretException.formatMessage(label, weaknesses));
    }

    public static String formatMessage(String label, EnumSet<WeakSecretError> weaknesses) {
        StringBuilder details = new StringBuilder();
        details.append(label).append(" does not meet the current policy and complexity requirements. ");
        details.append(LINE_SEP);
        int count = 0;
        for (WeakSecretError weakness : weaknesses) {
            details.append(weakness.getDescription());
            if (++count >= weaknesses.size()) continue;
            details.append(LINE_SEP);
        }
        return details.toString();
    }
}

