/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.ClusterEndpointPrincipal;
import com.hazelcast.security.ClusterIdentityPrincipal;
import com.hazelcast.security.ClusterRolePrincipal;
import com.hazelcast.security.EndpointCallback;
import com.hazelcast.security.HazelcastPrincipal;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class ClusterLoginModule
implements LoginModule {
    public static final String OPTION_SKIP_IDENTITY = "skipIdentity";
    public static final String OPTION_SKIP_ROLE = "skipRole";
    public static final String OPTION_SKIP_ENDPOINT = "skipEndpoint";
    protected static final String SHARED_STATE_IDENTITY = "hazelcast.last.identity";
    protected final ILogger logger = Logger.getLogger(this.getClass().getName());
    protected String endpoint;
    protected Subject subject;
    protected Map<String, ?> options;
    protected Map sharedState;
    protected boolean loginSucceeded;
    protected boolean commitSucceeded;
    protected CallbackHandler callbackHandler;
    private Set<String> assignedRoles = new HashSet<String>();

    @Override
    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.onInitialize();
    }

    @Override
    public final boolean login() throws LoginException {
        if (!this.getBoolOption(OPTION_SKIP_ENDPOINT, false)) {
            EndpointCallback ecb = new EndpointCallback();
            try {
                this.callbackHandler.handle(new Callback[]{ecb});
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Retrieving the remote address failed", e);
            }
            this.endpoint = ecb.getEndpoint();
            if (this.endpoint == null) {
                this.logger.log(Level.WARNING, "Remote address is empty!");
            }
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.log(Level.FINEST, "Authenticating request from " + this.getEndpointString());
        }
        this.loginSucceeded = this.onLogin();
        String name = this.getName();
        if (this.loginSucceeded && !this.isSkipIdentity() && name != null) {
            this.sharedState.put(SHARED_STATE_IDENTITY, name);
        }
        return this.loginSucceeded;
    }

    @Override
    public final boolean commit() throws LoginException {
        if (!this.loginSucceeded) {
            this.logger.log(Level.WARNING, "Authentication has been failed! Endpoint " + this.getEndpointString());
            return false;
        }
        String name = this.getName();
        this.logger.log(Level.FINEST, "Committing authentication from " + name);
        Set<Principal> principals = this.subject.getPrincipals();
        if (name != null && !this.isSkipIdentity()) {
            this.replaceTypedPrincipal(principals, new ClusterIdentityPrincipal(name));
        }
        if (this.endpoint != null && !this.getBoolOption(OPTION_SKIP_ENDPOINT, false)) {
            this.replaceTypedPrincipal(principals, new ClusterEndpointPrincipal(this.endpoint));
        }
        if (!this.isSkipRole()) {
            for (String role : this.assignedRoles) {
                principals.add(new ClusterRolePrincipal(role));
            }
        }
        this.commitSucceeded = this.onCommit();
        return this.commitSucceeded;
    }

    private void replaceTypedPrincipal(Set<Principal> principals, Principal newPrincipal) {
        Class<?> cls = newPrincipal.getClass();
        Iterator<Principal> it = principals.iterator();
        while (it.hasNext()) {
            if (!cls.isInstance(it.next())) continue;
            it.remove();
        }
        principals.add(newPrincipal);
    }

    @Override
    public final boolean abort() {
        this.logger.log(Level.FINEST, "Aborting authentication");
        boolean abort = this.onAbort();
        this.clearSubject();
        this.loginSucceeded = false;
        this.commitSucceeded = false;
        return abort;
    }

    @Override
    public final boolean logout() throws LoginException {
        this.logger.log(Level.FINEST, "Logging out");
        boolean logout = this.onLogout();
        this.clearSubject();
        this.loginSucceeded = false;
        this.commitSucceeded = false;
        return logout;
    }

    private void clearSubject() {
        Iterator<Principal> it = this.subject.getPrincipals().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof HazelcastPrincipal)) continue;
            it.remove();
        }
    }

    protected abstract boolean onLogin() throws LoginException;

    protected abstract String getName();

    protected void onInitialize() {
    }

    protected boolean onCommit() {
        return true;
    }

    protected boolean onAbort() {
        return true;
    }

    protected boolean onLogout() throws LoginException {
        return true;
    }

    protected void addRole(String roleName) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Assigning role: %s", roleName);
        }
        this.assignedRoles.add(roleName);
    }

    protected String getStringOption(String optionName, String defaultValue) {
        String option = this.getOptionInternal(optionName);
        return Objects.toString(option, defaultValue);
    }

    protected boolean getBoolOption(String optionName, boolean defaultValue) {
        String option = this.getOptionInternal(optionName);
        return option != null ? Boolean.parseBoolean(option) : defaultValue;
    }

    protected int getIntOption(String optionName, int defaultValue) {
        String option = this.getOptionInternal(optionName);
        return option != null ? Integer.parseInt(option) : defaultValue;
    }

    protected boolean isSkipRole() {
        return this.getBoolOption(OPTION_SKIP_ROLE, false);
    }

    protected boolean isSkipIdentity() {
        return this.getBoolOption(OPTION_SKIP_IDENTITY, false);
    }

    protected String getLastIdentity() {
        return (String)this.sharedState.get(SHARED_STATE_IDENTITY);
    }

    private String getOptionInternal(String optionName) {
        if (this.options == null) {
            return null;
        }
        Object option = this.options.get(optionName);
        return option != null ? option.toString() : null;
    }

    private String getEndpointString() {
        return this.endpoint == null ? "<undefined>" : this.endpoint;
    }
}

