/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.scheduledexecutor.impl.AbstractScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.CapacityPermit;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorMemberOwnedContainer;
import com.hazelcast.spi.impl.NodeEngine;

public class ScheduledExecutorMemberBin
extends AbstractScheduledExecutorContainerHolder {
    private final ILogger logger;
    private final ConstructorFunction<String, ScheduledExecutorContainer> containerConstructorFunction;

    public ScheduledExecutorMemberBin(NodeEngine nodeEngine, DistributedScheduledExecutorService service) {
        super(nodeEngine);
        this.logger = nodeEngine.getLogger(this.getClass());
        this.containerConstructorFunction = name -> {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("[Partition: -1] Create new scheduled executor container with name: %s", name);
            }
            ScheduledExecutorConfig config = nodeEngine.getConfig().findScheduledExecutorConfig((String)name);
            return new ScheduledExecutorMemberOwnedContainer((String)name, this.newPermitFor((String)name, service, config), nodeEngine, config.isStatisticsEnabled(), config.getUserCodeNamespace());
        };
    }

    CapacityPermit newPermitFor(String name, DistributedScheduledExecutorService service, ScheduledExecutorConfig config) {
        if (config.getCapacity() == 0 || config.getCapacityPolicy() == ScheduledExecutorConfig.CapacityPolicy.PER_PARTITION) {
            return DistributedScheduledExecutorService.NOOP_PERMIT;
        }
        return service.permitFor(name, config);
    }

    @Override
    public ConstructorFunction<String, ScheduledExecutorContainer> getContainerConstructorFunction() {
        return this.containerConstructorFunction;
    }
}

