/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.bplustree.TStoreBTreeAllocator;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.recordstore.EnterpriseTieredRecordStore;
import com.hazelcast.spi.properties.HazelcastProperties;

class TStoreBTreeAllocatorDependencies
implements TStoreBTreeAllocator.Dependencies {
    private static final ThreadLocal<byte[]> BUFFER = ThreadLocal.withInitial(TStoreBTreeAllocatorDependencies::newBuffer);
    private static final int BUFFER_SIZE = 4096;
    private final EnterpriseMapServiceContext mapServiceContext;
    private final InternalPartitionService partitionService;
    private final String mapName;
    private final MapContainer mapContainer;
    private final CompactionManager compactionManager;
    private final HazelcastProperties properties;

    TStoreBTreeAllocatorDependencies(InternalPartitionService partitionService, EnterpriseMapServiceContext mapServiceContext, MapContainer mapContainer, CompactionManager compactionManager, HazelcastProperties properties) {
        this.partitionService = partitionService;
        this.mapServiceContext = mapServiceContext;
        this.mapContainer = mapContainer;
        this.mapName = mapContainer.getName();
        this.compactionManager = compactionManager;
        this.properties = properties;
    }

    @Override
    public int getPartition(Data key) {
        return this.partitionService.getPartitionId(key);
    }

    @Override
    public State getState(int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        EnterpriseTieredRecordStore recordStore = (EnterpriseTieredRecordStore)partitionContainer.getRecordStore(this.mapName);
        return recordStore.getState();
    }

    @Override
    public Index getIndex(int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        EnterpriseTieredRecordStore recordStore = (EnterpriseTieredRecordStore)partitionContainer.getRecordStore(this.mapName);
        return recordStore.getIndex();
    }

    @Override
    public Data getRecordValue(int partitionId, Data key, long recordLogicalAddress) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        EnterpriseTieredRecordStore recordStore = (EnterpriseTieredRecordStore)partitionContainer.getRecordStore(this.mapName);
        TieredStoreRecordProcessor recordProcessor = recordStore.getRecordProcessor();
        if (recordProcessor.getHybridLog().isInMemory(recordLogicalAddress)) {
            int currentThreadIndex = recordProcessor.getEpoch().getCurrentThreadIndex();
            TieredStoreRecord readRecord = recordProcessor.readRecordForReadOnly(recordLogicalAddress, TieredStoreRecordProcessor.NOP_REMAPPER, currentThreadIndex);
            assert (readRecord != Index.RETRY_RECORD);
            return readRecord.getValue();
        }
        byte[] buf = BUFFER.get();
        return recordProcessor.readRecordValueFromDevice(recordLogicalAddress, key, buf);
    }

    @Override
    public PartitionIdSet newPartitionIdSet() {
        int partitionCount = this.partitionService.getPartitionCount();
        return new PartitionIdSet(partitionCount);
    }

    @Override
    public CompactionManager getCompactionManager() {
        return this.compactionManager;
    }

    @Override
    public HazelcastProperties getProperties() {
        return this.properties;
    }

    @Override
    public boolean shouldUseGlobalIndex() {
        return this.mapContainer.shouldUseGlobalIndex();
    }

    private static byte[] newBuffer() {
        return new byte[4096];
    }
}

