/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.TSAbstractIndexImpl;
import com.hazelcast.query.impl.getters.Extractors;

public class TSGlobalIndexImpl
extends TSAbstractIndexImpl {
    private final GlobalIndexPartitionTracker partitionTracker;

    public TSGlobalIndexImpl(Node node, IndexConfig config, InternalSerializationService ss, Extractors extractors, PerIndexStats stats, int partitionCount, String mapName) {
        super(node, config, ss, extractors, stats, mapName, -1);
        this.partitionTracker = new GlobalIndexPartitionTracker(partitionCount);
    }

    @Override
    HybridLog createIndexHybridLog(TieredStoreService tieredStoreService, TieredStoreUser user, MapContainer mapContainer, IndexConfig indexConfig, String tag, int partitionId) {
        return tieredStoreService.createGlobalIndexHybridLog(TieredStoreUser.BTREE, mapContainer, indexConfig, tag);
    }

    @Override
    public final boolean hasPartitionIndexed(int partitionId) {
        return this.partitionTracker.isIndexed(partitionId);
    }

    @Override
    public final boolean allPartitionsIndexed(int ownedPartitionCount) {
        return ownedPartitionCount < 0 || this.partitionTracker.indexedCount() == ownedPartitionCount;
    }

    @Override
    public final void beginPartitionUpdate() {
        this.partitionTracker.beginPartitionUpdate();
    }

    @Override
    public final void markPartitionAsIndexed(int partitionId) {
        this.partitionTracker.partitionIndexed(partitionId);
    }

    @Override
    public final void markPartitionAsUnindexed(int partitionId) {
        this.partitionTracker.partitionUnindexed(partitionId);
    }

    @Override
    public final GlobalIndexPartitionTracker.PartitionStamp getPartitionStamp() {
        return this.partitionTracker.getPartitionStamp();
    }

    @Override
    public final boolean validatePartitionStamp(long stamp) {
        return this.partitionTracker.validatePartitionStamp(stamp);
    }

    @Override
    public String toString() {
        return "TSGlobalIndexImpl{} " + super.toString();
    }
}

