/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;

public class OnHeapEntryFactory
implements MapEntryFactory<QueryableEntry> {
    private final EnterpriseSerializationService ess;
    private final Extractors extractors;

    public OnHeapEntryFactory(EnterpriseSerializationService ess, Extractors extractors) {
        this.ess = ess;
        this.extractors = extractors;
    }

    @Override
    public CachedQueryEntry create(Data key, Data value) {
        Data heapData = this.toHeapData(key);
        Data heapValue = this.toHeapData(value);
        return new CachedQueryEntry(this.ess, heapData, heapValue, this.extractors);
    }

    private Data toHeapData(Data data) {
        if (data instanceof NativeMemoryData) {
            NativeMemoryData nativeMemoryData = (NativeMemoryData)data;
            if (nativeMemoryData.totalSize() == 0) {
                return null;
            }
            try {
                return this.ess.toData((Object)nativeMemoryData, DataType.HEAP);
            }
            catch (IllegalArgumentException | NegativeArraySizeException e) {
                throw new IllegalArgumentException("Invalid native data: " + String.valueOf(nativeMemoryData), e);
            }
        }
        return data;
    }
}

