/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.DefaultHiDensityRecordProcessor;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystemImpl;
import com.hazelcast.map.impl.recordstore.expiry.HDExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.HDExpiryMetadataAccessor;
import com.hazelcast.map.impl.recordstore.expiry.HDExpirySlotAccessorFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public class HDExpirySystemImpl
extends ExpirySystemImpl {
    private static final ThreadLocal<HDExpiryMetadata> HD_EXPIRY_METADATA_THREAD_LOCAL = ThreadLocal.withInitial(HDExpiryMetadata::new);
    private final EnterpriseSerializationService ess;
    private final HiDensityStorageInfo hdStorageInfo;
    private DefaultHiDensityRecordProcessor memoryBlockProcessor;

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public HDExpirySystemImpl(RecordStore recordStore, MapContainer mapContainer, MapServiceContext mapServiceContext) {
        super(recordStore, mapContainer, mapServiceContext);
        SerializationService ss = mapServiceContext.getNodeEngine().getSerializationService();
        this.ess = (EnterpriseSerializationService)ss;
        this.hdStorageInfo = ((EnterpriseMapContainer)mapContainer).getHDStorageInfo();
    }

    @Override
    protected Map<Data, ExpiryMetadata> createExpiryTimeByKeyMap() {
        HDExpiryMetadataAccessor accessor = new HDExpiryMetadataAccessor(this.ess);
        HDExpirySlotAccessorFactory slotAccessorFactory = new HDExpirySlotAccessorFactory();
        this.memoryBlockProcessor = new DefaultHiDensityRecordProcessor<HDExpiryMetadata>(this.ess, accessor, this.ess.getMemoryManager(), this.hdStorageInfo);
        return new BinaryElasticHashMap<ExpiryMetadata>(16, slotAccessorFactory, this.memoryBlockProcessor);
    }

    @Override
    protected ExpiryMetadata createExpiryMetadata(long ttlMillis, long maxIdleMillis, long expirationTime, long lastUpdateTime) {
        assert (this.memoryBlockProcessor != null);
        long address = this.memoryBlockProcessor.allocate(HDExpiryMetadata.SIZE);
        return new HDExpiryMetadata(address).setTtl(ttlMillis).setMaxIdle(maxIdleMillis).setExpirationTime(expirationTime).setLastUpdateTime(lastUpdateTime);
    }

    @Override
    protected ExpiryMetadata getExpiryMetadataForExpiryCheck(Data key, Map<Data, ExpiryMetadata> expireTimeByKey) {
        long nativeValueAddress = ((BinaryElasticHashMap)expireTimeByKey).getNativeValueAddress(key);
        if (nativeValueAddress == 0L) {
            return ExpiryMetadata.NULL;
        }
        return HD_EXPIRY_METADATA_THREAD_LOCAL.get().reset(nativeValueAddress);
    }

    @Override
    protected Iterator<Map.Entry<Data, ExpiryMetadata>> initIteratorOf(Map<Data, ExpiryMetadata> expireTimeByKey) {
        BinaryElasticHashMap map = (BinaryElasticHashMap)expireTimeByKey;
        return map.entryIter(false);
    }

    @Override
    protected void callRemove(Data key, Map<Data, ExpiryMetadata> expireTimeByKey) {
        BinaryElasticHashMap map = (BinaryElasticHashMap)expireTimeByKey;
        map.deleteInternal(key, false);
    }

    @Override
    public void clear() {
        Map<Data, ExpiryMetadata> map = this.getOrCreateExpireTimeByKeyMap(false);
        if (map instanceof BinaryElasticHashMap) {
            BinaryElasticHashMap hashMap = (BinaryElasticHashMap)map;
            hashMap.clearWithoutKeyDisposal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Disposable createDisposable() {
        try {
            Map<Data, ExpiryMetadata> map = this.getOrCreateExpireTimeByKeyMap(false);
            if (map instanceof BinaryElasticHashMap) {
                BinaryElasticHashMap hashMap = (BinaryElasticHashMap)map;
                Disposable disposable = () -> hashMap.dispose();
                return disposable;
            }
            Disposable disposable = EMPTY_DISPOSABLE;
            return disposable;
        }
        finally {
            HD_EXPIRY_METADATA_THREAD_LOCAL.remove();
        }
    }
}

