/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.impl.ByteArrayAccessStrategy;
import com.hazelcast.internal.memory.impl.EndiannessUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.record.SimpleRecord;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;

public final class TieredStoreRecordWithVersion
extends TieredStoreRecord {
    public TieredStoreRecordWithVersion(TieredStoreRecordAccessor recordAccessor) {
        super(GlobalMemoryAccessorRegistry.AMEM, recordAccessor);
    }

    @Override
    public int getMetadataSize() {
        return 4;
    }

    private int getVersionOffset() {
        return this.getMetadataOffset();
    }

    @Override
    public int getVersion() {
        return this.readInt(this.getVersionOffset());
    }

    @Override
    public void setVersion(int version) {
        this.assertMutable();
        this.writeInt(this.getVersionOffset(), version);
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.SIMPLE_DATA_RECORD_READER_WRITER;
    }

    static Record makeRecordFrom(byte[] recordBytes) {
        Data dataValue = TieredStoreRecordWithVersion.getValueFromRecord(recordBytes);
        SimpleRecord<Data> record = new SimpleRecord<Data>(dataValue);
        int versionOffset = TieredStoreRecordWithVersion.getMetadataOffsetFromRecord(recordBytes);
        int version = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, versionOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setVersion(version);
        return record;
    }

    private static int getMetadataOffsetFromRecord(byte[] record) {
        return record.length - 4;
    }

    static Record makeRecordFrom(TieredStoreRecord record) {
        Data dataValue = ToHeapDataConverter.toHeapData(record.getValue());
        SimpleRecord<Data> onHeapRecord = new SimpleRecord<Data>(dataValue);
        onHeapRecord.setVersion(record.getVersion());
        return onHeapRecord;
    }
}

