/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.TieredStoreRecord;

public final class TieredStoreRecordFactory
implements RecordFactory<Data> {
    private final TieredStoreRecordProcessor recordProcessor;
    private final MapContainer mapContainer;
    private final Epoch epoch;

    public TieredStoreRecordFactory(MapContainer mapContainer, TieredStoreRecordProcessor recordProcessor, Epoch epoch) {
        this.recordProcessor = recordProcessor;
        this.mapContainer = mapContainer;
        this.epoch = epoch;
    }

    public TieredStoreRecord newRecord(Data key, Object value) {
        assert (key != null);
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            int currentThreadIndex = this.epoch.getCurrentThreadIndex();
            return this.newHDRecordWithExtras(key, value, 28, currentThreadIndex);
        }
        if (!hasEviction && !hasHotRestart) {
            int currentThreadIndex = this.epoch.getCurrentThreadIndex();
            return this.newHDRecordWithExtras(key, value, 4, currentThreadIndex);
        }
        throw new IllegalStateException("No tiered-store record type found matching with the provided " + String.valueOf(mapConfig));
    }

    public TieredStoreRecord newRecord(TieredStoreRecord record, Data newValue, int threadIndex) {
        Data key = record.getKey();
        int recordSize = this.recordProcessor.recordSize(key, newValue, record.getMetadataSize());
        TieredStoreRecord newRecord = this.recordProcessor.newPreparedRecord(recordSize, threadIndex);
        newRecord.setKey(key);
        newRecord.setValue(newValue);
        newRecord.setMetadata(record);
        return newRecord;
    }

    public TieredStoreRecord newHDRecordWithExtras(Data key, Object value, int metadataSize, int threadIndex) {
        Data dataValue = this.recordProcessor.toData(value, DataType.HEAP);
        int recordSize = this.recordProcessor.recordSize(key, dataValue, metadataSize);
        TieredStoreRecord record = this.recordProcessor.newPreparedRecord(recordSize, threadIndex);
        record.setKey(key);
        record.setValue(dataValue);
        record.setLastAccessTime(-1L);
        return record;
    }

    public TieredStoreRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }

    public EnterpriseMapContainer getMapContainer() {
        return (EnterpriseMapContainer)this.mapContainer;
    }
}

