/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.memory.NativeOutOfMemoryError;

public class HDRecordFactory
implements RecordFactory<Data> {
    private final HiDensityRecordProcessor<HDRecord> recordProcessor;
    private final MapContainer mapContainer;

    public HDRecordFactory(MapContainer mapContainer, HiDensityRecordProcessor<HDRecord> recordProcessor) {
        this.recordProcessor = recordProcessor;
        this.mapContainer = mapContainer;
    }

    @Override
    public Record<Data> newRecord(Data key, Object value) {
        assert (key != null);
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            return this.newHDRecordWithExtras(value, 36L);
        }
        if (!hasEviction && !hasHotRestart) {
            return this.newHDRecordWithExtras(value, 12L);
        }
        if (hasEviction && !hasHotRestart) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return this.newHDRecordWithExtras(value, 16L);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return this.newHDRecordWithExtras(value, 16L);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return this.newHDRecordWithExtras(value, 12L);
            }
            return this.newHDRecordWithExtras(value, 36L);
        }
        if (!hasEviction && hasHotRestart) {
            return this.newHDRecordWithExtras(value, 16L);
        }
        if (hasEviction && hasHotRestart) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return this.newHDRecordWithExtras(value, 20L);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return this.newHDRecordWithExtras(value, 20L);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return this.newHDRecordWithExtras(value, 16L);
            }
            return this.newHDRecordWithExtras(value, 36L);
        }
        throw new IllegalStateException("No HD record type found matching with the provided " + String.valueOf(mapConfig));
    }

    protected HDRecord newHDRecordWithExtras(Object value, long size) {
        long address = 0L;
        Data dataValue = null;
        try {
            address = this.recordProcessor.allocate(size);
            HDRecord record = (HDRecord)this.recordProcessor.newRecord();
            record.reset(address);
            dataValue = this.recordProcessor.toData(value, DataType.NATIVE);
            record.setValue(dataValue);
            record.setLastAccessTime(-1L);
            return record;
        }
        catch (NativeOutOfMemoryError error) {
            if (!HDRecordFactory.isNull(dataValue)) {
                this.recordProcessor.disposeData(dataValue);
            }
            if (address != 0L) {
                this.recordProcessor.dispose(address);
            }
            throw error;
        }
    }

    public HiDensityRecordProcessor<HDRecord> getRecordProcessor() {
        return this.recordProcessor;
    }

    static boolean isNull(Object object) {
        if (object == null) {
            return false;
        }
        NativeMemoryData memoryBlock = (NativeMemoryData)object;
        return memoryBlock.address() == 0L;
    }
}

