/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.JsonMetadata;

public class HDJsonMetadataRecord
extends MemoryBlock
implements JsonMetadata {
    public static final int SIZE = 16;
    public static final int KEY_OFFSET = 0;
    public static final int VALUE_OFFSET = 8;
    private final EnterpriseSerializationService ess;

    public HDJsonMetadataRecord(EnterpriseSerializationService ess) {
        super(GlobalMemoryAccessorRegistry.AMEM);
        this.ess = ess;
    }

    public void setValue(Data value) {
        if (value == null) {
            this.setValueAddress(0L);
            return;
        }
        assert (value instanceof NativeMemoryData);
        this.setValueAddress(((NativeMemoryData)value).address());
    }

    public void setValueAddress(long valueAddress) {
        this.writeLong(8L, valueAddress);
    }

    public NativeMemoryData getValue() {
        if (this.address == 0L) {
            return null;
        }
        long valueAddress = this.getValueAddress();
        if (valueAddress == 0L) {
            return null;
        }
        return new NativeMemoryData().reset(valueAddress);
    }

    public long getValueAddress() {
        return this.readLong(8L);
    }

    public void setKey(Data value) {
        if (value == null) {
            this.setKeyAddress(0L);
            return;
        }
        assert (value instanceof NativeMemoryData);
        this.setKeyAddress(((NativeMemoryData)value).address());
    }

    public void setKeyAddress(long valueAddress) {
        this.writeLong(0L, valueAddress);
    }

    public NativeMemoryData getKey() {
        if (this.address == 0L) {
            return null;
        }
        long keyAddress = this.getKeyAddress();
        if (keyAddress == 0L) {
            return null;
        }
        return new NativeMemoryData().reset(keyAddress);
    }

    public long getKeyAddress() {
        return this.readLong(0L);
    }

    public HDJsonMetadataRecord reset(long address) {
        this.setAddress(address);
        this.setSize(this.getSize());
        return this;
    }

    public int getSize() {
        return 16;
    }

    @Override
    public Object getKeyMetadata() {
        return this.ess.toObject(this.getKey());
    }

    @Override
    public Object getValueMetadata() {
        return this.ess.toObject(this.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HDJsonMetadataRecord record = (HDJsonMetadataRecord)o;
        return this.address == record.address && this.size == record.size;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.address ^ this.address >>> 32);
        result = 31 * result + this.size;
        return result;
    }

    @Override
    public String toString() {
        return this.address() == 0L ? "HDJsonMetadataRecord{NULL}" : "HDJsonMetadataRecord{keyAddress=" + this.getKeyAddress() + "valueAddress=" + this.getValueAddress() + "}";
    }
}

