/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.EnterpriseTieredRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public final class TieredStoreMapFlushAndSyncStateOperation
extends Operation
implements IdentifiedDataSerializable {
    private PartitionContainer partitionContainer;
    private CompletableFuture<Void> rootFuture;

    public TieredStoreMapFlushAndSyncStateOperation() {
    }

    public TieredStoreMapFlushAndSyncStateOperation(PartitionContainer partitionContainer, CompletableFuture<Void> rootFuture) {
        this.partitionContainer = partitionContainer;
        this.rootFuture = rootFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int mapCount = this.partitionContainer.getAllRecordStores().size();
        CompletableFuture[] futures = new CompletableFuture[mapCount];
        int index = 0;
        for (RecordStore recordStore : this.partitionContainer.getAllRecordStores()) {
            recordStore.beforeOperation();
            try {
                EnterpriseTieredRecordStore tsRecordStore = (EnterpriseTieredRecordStore)recordStore;
                CompletableFuture<Void> future = tsRecordStore.flushAndSyncState();
                futures[index++] = future;
            }
            finally {
                recordStore.afterOperation();
            }
        }
        CompletableFuture.allOf(futures).whenCompleteAsync((unused, throwable) -> this.rootFuture.complete(null), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only used locally!");
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only used locally!");
    }

    @Override
    public int getFactoryId() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only used locally!");
    }

    @Override
    public int getClassId() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only used locally!");
    }

    @Override
    public TenantControl getTenantControl() {
        return TenantControl.NOOP_TENANT_CONTROL;
    }

    @Override
    public boolean requiresTenantContext() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }
}

