/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.internal.monitor.impl.LocalRecordStoreStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalReplicationStatsImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.MapIndexInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapReplicationStateHolder
implements IdentifiedDataSerializable,
Versioned {
    protected transient Map<String, RecordStore<Record>> storesByMapName;
    protected transient Map<String, LocalReplicationStatsImpl> statsByMapName = new ConcurrentHashMap<String, LocalReplicationStatsImpl>();
    protected transient Map<String, List> data;
    protected transient Map<String, Boolean> loaded;
    protected transient List<MapIndexInfo> mapIndexInfos;
    protected Map<String, int[]> merkleTreeDiffByMapName = Collections.emptyMap();
    protected MapReplicationOperation operation;
    private Map<String, LocalRecordStoreStats> recordStoreStatsPerMapName;

    public void setMerkleTreeDiffByMapName(Map<String, int[]> merkleTreeDiffByMapName) {
        this.merkleTreeDiffByMapName = merkleTreeDiffByMapName == null ? Collections.emptyMap() : merkleTreeDiffByMapName;
    }

    public void setOperation(MapReplicationOperation operation) {
        this.operation = operation;
    }

    void prepare(PartitionContainer container, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        this.storesByMapName = MapUtil.createHashMap(namespaces.size());
        this.loaded = MapUtil.createHashMap(namespaces.size());
        this.mapIndexInfos = new ArrayList<MapIndexInfo>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            MapContainer mapContainer;
            MapConfig mapConfig;
            ObjectNamespace mapNamespace = (ObjectNamespace)namespace;
            String mapName = mapNamespace.getObjectName();
            RecordStore recordStore = container.getExistingRecordStore(mapName);
            if (recordStore == null || (mapConfig = (mapContainer = recordStore.getMapContainer()).getMapConfig()).getTotalBackupCount() < replicaIndex) continue;
            this.loaded.put(mapName, recordStore.isLoaded());
            this.storesByMapName.put(mapName, recordStore);
            this.statsByMapName.put(mapName, mapContainer.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(mapName).getReplicationStats());
            HashSet<IndexConfig> indexConfigs = new HashSet<IndexConfig>();
            if (mapContainer.shouldUseGlobalIndex()) {
                indexRegistry = mapContainer.getGlobalIndexRegistry();
                for (InternalIndex index : indexRegistry.getIndexes()) {
                    indexConfigs.add(index.getConfig());
                }
                indexConfigs.addAll(indexRegistry.getIndexDefinitions());
            } else {
                indexRegistry = mapContainer.getOrCreateIndexRegistry(container.getPartitionId());
                if (indexRegistry != null && indexRegistry.haveAtLeastOneIndexOrDefinition()) {
                    for (InternalIndex index : indexRegistry.getIndexes()) {
                        indexConfigs.add(index.getConfig());
                    }
                    indexConfigs.addAll(indexRegistry.getIndexDefinitions());
                }
            }
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapName);
            mapIndexInfo.addIndexCofigs(indexConfigs);
            this.mapIndexInfos.add(mapIndexInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyState() {
        RecordStore recordStore;
        String mapName;
        ThreadUtil.assertRunningOnPartitionThread();
        this.applyIndexesState();
        if (!MapUtil.isNullOrEmpty(this.data)) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                mapName = entry.getKey();
                List keyRecordExpiry = (List)entry.getValue();
                recordStore = this.operation.getRecordStore(mapName);
                recordStore.beforeOperation();
                try {
                    this.initializeRecordStore(mapName, recordStore);
                    recordStore.setPreMigrationLoadedStatus(this.loaded.get(mapName));
                    MapContainer mapContainer = recordStore.getMapContainer();
                    PartitionContainer partitionContainer = recordStore.getMapContainer().getMapServiceContext().getPartitionContainer(this.operation.getPartitionId());
                    for (Map.Entry<String, IndexConfig> indexDefinition : mapContainer.getIndexDefinitions().entrySet()) {
                        IndexRegistry indexRegistry = mapContainer.getOrCreateIndexRegistry(partitionContainer.getPartitionId());
                        indexRegistry.addOrGetIndex(indexDefinition.getValue());
                    }
                    IndexRegistry indexRegistry = mapContainer.getOrCreateIndexRegistry(partitionContainer.getPartitionId());
                    boolean populateIndexes = MapReplicationStateHolder.indexesMustBePopulated(indexRegistry, this.operation);
                    InternalIndex[] indexesSnapshot = null;
                    if (populateIndexes) {
                        indexesSnapshot = indexRegistry.getIndexes();
                        IndexRegistry.beginPartitionUpdate(indexesSnapshot);
                        indexRegistry.clearAll();
                    }
                    long nowInMillis = Clock.currentTimeMillis();
                    this.forEachReplicatedRecord(keyRecordExpiry, mapContainer, recordStore, populateIndexes, nowInMillis);
                    if (!populateIndexes) continue;
                    IndexRegistry.markPartitionAsIndexed(partitionContainer.getPartitionId(), indexesSnapshot);
                }
                finally {
                    recordStore.afterOperation();
                }
            }
        }
        for (Map.Entry<String, Object> entry : this.recordStoreStatsPerMapName.entrySet()) {
            mapName = entry.getKey();
            LocalRecordStoreStats stats = (LocalRecordStoreStats)entry.getValue();
            recordStore = this.operation.getRecordStore(mapName);
            recordStore.setLocalRecordStoreStats(stats);
        }
    }

    private void forEachReplicatedRecord(List keyRecordExpiry, MapContainer mapContainer, RecordStore recordStore, boolean populateIndexes, long nowInMillis) {
        long ownedEntryCountOnThisNode = this.entryCountOnThisNode(mapContainer);
        EvictionConfig evictionConfig = mapContainer.getMapConfig().getEvictionConfig();
        boolean perNodeEvictionConfigured = mapContainer.getEvictor() != Evictor.NULL_EVICTOR && evictionConfig.getMaxSizePolicy() == MaxSizePolicy.PER_NODE;
        for (int i = 0; i < keyRecordExpiry.size(); i += 3) {
            Data dataKey = (Data)keyRecordExpiry.get(i);
            Record record = (Record)keyRecordExpiry.get(i + 1);
            ExpiryMetadata expiryMetadata = (ExpiryMetadata)keyRecordExpiry.get(i + 2);
            if (perNodeEvictionConfigured) {
                if (ownedEntryCountOnThisNode >= (long)evictionConfig.getSize()) {
                    if (this.operation.getReplicaIndex() == 0) {
                        recordStore.doPostEvictionOperations(dataKey, record.getValue(), ExpiryReason.NOT_EXPIRED);
                    }
                } else {
                    recordStore.putOrUpdateReplicatedRecord(dataKey, record, expiryMetadata, populateIndexes, nowInMillis);
                    ++ownedEntryCountOnThisNode;
                }
            } else {
                recordStore.putOrUpdateReplicatedRecord(dataKey, record, expiryMetadata, populateIndexes, nowInMillis);
                if (recordStore.shouldEvict()) {
                    recordStore.evictEntries(dataKey);
                    break;
                }
            }
            recordStore.disposeDeferredBlocks();
        }
    }

    protected void initializeRecordStore(String mapName, RecordStore recordStore) {
        if (!this.merkleTreeDiffByMapName.containsKey(mapName)) {
            recordStore.reset();
        }
    }

    private long entryCountOnThisNode(MapContainer mapContainer) {
        int replicaIndex = this.operation.getReplicaIndex();
        long owned = 0L;
        if (mapContainer.getEvictor() != Evictor.NULL_EVICTOR && MaxSizePolicy.PER_NODE == mapContainer.getMapConfig().getEvictionConfig().getMaxSizePolicy()) {
            MapService mapService = (MapService)this.operation.getService();
            MapServiceContext mapServiceContext = mapService.getMapServiceContext();
            IPartitionService partitionService = mapServiceContext.getNodeEngine().getPartitionService();
            int partitionCount = partitionService.getPartitionCount();
            for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                RecordStore store;
                if (!(replicaIndex == 0 ? partitionService.isPartitionOwner(partitionId) : !partitionService.isPartitionOwner(partitionId)) || (store = mapServiceContext.getExistingRecordStore(partitionId, mapContainer.getName())) == null) continue;
                owned += (long)store.size();
            }
        }
        return owned;
    }

    private void applyIndexesState() {
        if (this.mapIndexInfos != null) {
            for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
                this.addIndexes(mapIndexInfo.getMapName(), mapIndexInfo.getIndexConfigs());
            }
        }
    }

    private void addIndexes(String mapName, Collection<IndexConfig> indexConfigs) {
        if (indexConfigs == null) {
            return;
        }
        RecordStore recordStore = this.operation.getRecordStore(mapName);
        MapContainer mapContainer = recordStore.getMapContainer();
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        if (mapContainer.shouldUseGlobalIndex()) {
            for (IndexConfig indexConfig : indexConfigs) {
                IndexRegistry indexRegistry = mapContainer.getGlobalIndexRegistry();
                if (indexRegistry.getIndex(indexConfig.getName()) == null) {
                    indexRegistry.addOrGetIndex(indexConfig);
                }
                mapServiceContext.registerIndex(mapName, indexConfig);
            }
        } else {
            IndexRegistry indexRegistry = mapContainer.getOrCreateIndexRegistry(this.operation.getPartitionId());
            indexRegistry.createIndexesFromRecordedDefinitions();
            for (IndexConfig indexConfig : indexConfigs) {
                indexRegistry.addOrGetIndex(indexConfig);
                mapServiceContext.registerIndex(mapName, indexConfig);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.storesByMapName.size());
        for (Map.Entry<String, RecordStore<Record>> entry : this.storesByMapName.entrySet()) {
            String mapName = entry.getKey();
            RecordStore<Record> recordStore = entry.getValue();
            out.writeString(mapName);
            this.writeRecordStore(mapName, recordStore, out);
            recordStore.getLocalRecordStoreStats().writeData(out);
        }
        out.writeInt(this.loaded.size());
        for (Map.Entry<String, Object> entry : this.loaded.entrySet()) {
            out.writeString(entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        SerializationUtil.writeList(this.mapIndexInfos, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecordStore(String mapName, RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        recordStore.beforeOperation();
        try {
            if (this.merkleTreeDiffByMapName.containsKey(mapName)) {
                out.writeBoolean(true);
                this.writeDifferentialData(mapName, recordStore, out);
            } else {
                out.writeBoolean(false);
                this.writeRecordStoreData(recordStore, out);
            }
        }
        finally {
            recordStore.afterOperation();
        }
    }

    protected void writeDifferentialData(String mapName, RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeRecordStoreData(RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        SerializationService ss = MapReplicationStateHolder.getSerializationService(recordStore.getMapContainer());
        out.writeInt(recordStore.size());
        recordStore.forEach((dataKey, record) -> {
            try {
                IOUtil.writeData(out, dataKey);
                Records.writeRecord(out, record, ss.toData(record.getValue()));
                Records.writeExpiry(out, recordStore.getExpirySystem().getExpiryMetadata((Data)dataKey));
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }, this.operation.getReplicaIndex() != 0, true);
        LocalReplicationStatsImpl replicationStats = this.statsByMapName.get(recordStore.getName());
        replicationStats.incrementFullPartitionReplicationCount();
        replicationStats.incrementFullPartitionReplicationRecordsCount(recordStore.size());
    }

    protected static SerializationService getSerializationService(MapContainer mapContainer) {
        return mapContainer.getMapServiceContext().getNodeEngine().getSerializationService();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.data = MapUtil.createHashMap(size);
        this.merkleTreeDiffByMapName = new HashMap<String, int[]>();
        this.recordStoreStatsPerMapName = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            String mapName = in.readString();
            boolean differentialReplication = in.readBoolean();
            if (differentialReplication) {
                this.readDifferentialData(mapName, in);
                continue;
            }
            this.readRecordStoreData(mapName, in);
        }
        int loadedSize = in.readInt();
        this.loaded = MapUtil.createHashMap(loadedSize);
        for (int i = 0; i < loadedSize; ++i) {
            this.loaded.put(in.readString(), in.readBoolean());
        }
        this.mapIndexInfos = SerializationUtil.readList(in);
    }

    protected void readDifferentialData(String mapName, ObjectDataInput in) throws IOException {
        int[] diffNodeOrder = in.readIntArray();
        this.merkleTreeDiffByMapName.put(mapName, diffNodeOrder);
        this.readRecordStoreData(mapName, in);
    }

    protected void readRecordStoreData(String mapName, ObjectDataInput in) throws IOException {
        int numOfRecords = in.readInt();
        ArrayList<Object> keyRecord = new ArrayList<Object>(numOfRecords * 3);
        for (int j = 0; j < numOfRecords; ++j) {
            Data dataKey = IOUtil.readData(in);
            Record record = Records.readRecord(in);
            ExpiryMetadata expiryMetadata = Records.readExpiry(in);
            keyRecord.add(dataKey);
            keyRecord.add(record);
            keyRecord.add(expiryMetadata);
        }
        LocalRecordStoreStatsImpl stats = new LocalRecordStoreStatsImpl();
        stats.readData(in);
        this.recordStoreStatsPerMapName.put(mapName, stats);
        this.data.put(mapName, keyRecord);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 103;
    }

    private static boolean indexesMustBePopulated(IndexRegistry indexRegistry, MapReplicationOperation operation) {
        if (!indexRegistry.haveAtLeastOneIndex()) {
            return false;
        }
        if (indexRegistry.isGlobal()) {
            return false;
        }
        return operation.getReplicaIndex() == 0;
    }
}

