/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.iterator;

import com.hazelcast.internal.util.ConstructorFunction;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class AbstractMapIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    protected static final int DEFAULT_FETCH_SIZE = 100;
    private final int partitionCount;
    private Iterator<Map.Entry<K, V>> lastReadIterator;
    private final ConstructorFunction<Integer, Iterator<Map.Entry<K, V>>> createPartitionIterator;
    private Iterator<Map.Entry<K, V>> it;
    private int idx;

    protected AbstractMapIterator(ConstructorFunction<Integer, Iterator<Map.Entry<K, V>>> createPartitionIterator, int partitionCount) {
        this.createPartitionIterator = createPartitionIterator;
        this.partitionCount = partitionCount;
        this.idx = 0;
        this.it = createPartitionIterator.createNew(this.idx);
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.hasNext()) {
            if (this.it != this.lastReadIterator) {
                this.lastReadIterator = this.it;
            }
            return this.it.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        while (!this.it.hasNext()) {
            if (this.idx == this.partitionCount - 1) {
                return false;
            }
            this.it = this.createPartitionIterator.createNew(++this.idx);
        }
        return true;
    }

    @Override
    public void remove() {
        if (this.lastReadIterator == null) {
            throw new IllegalStateException("Iterator.next() must be called before remove()!");
        }
        this.lastReadIterator.remove();
    }
}

