/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.util;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.LicenseExtractorV2;
import com.hazelcast.license.extractor.LicenseExtractorV3;
import com.hazelcast.license.extractor.LicenseExtractorV4;
import com.hazelcast.license.extractor.LicenseExtractorV5;
import com.hazelcast.license.extractor.LicenseExtractorV6;
import com.hazelcast.license.extractor.LicenseExtractorV7;
import com.hazelcast.license.nlc.BuiltInLicenseProviderFactory;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class LicenseHelper {
    private LicenseHelper() {
    }

    public static int extractHazelcastMajorMinorVersionAsInt(String version) {
        String[] stringArray = version.split("\\.");
        if (stringArray.length > 2) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            return LicenseHelper.a(n, n2);
        }
        String[] stringArray2 = stringArray[1].split("-");
        int n = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray2[0]);
        return LicenseHelper.a(n, n3);
    }

    private static int a(int n, int n2) {
        boolean bl = n2 > 9 && n2 < 100;
        if (bl) {
            return n * 100 + n2;
        }
        return n * 10 + n2;
    }

    public static boolean isExpired(License license) {
        License license2;
        return ZonedDateTime.now(ZoneOffset.UTC).isAfter(LicenseHelper.getExpiryDateWithGracePeriod(license2));
    }

    public static ZonedDateTime getExpiryDateWithGracePeriod(License license) {
        License license2;
        return license.getExpiryDate().plusMonths(license2.getGracePeriod());
    }

    /*
     * WARNING - void declaration
     */
    public static License getLicense(String licenseKey, String versionString) {
        void var1_2;
        License license;
        if (licenseKey == null) {
            throw new InvalidLicenseException("License Key not configured!");
        }
        try {
            license = LicenseExtractorV6.extractLicense(licenseKey);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            try {
                license = LicenseExtractorV5.extractLicense(licenseKey);
            }
            catch (InvalidLicenseException invalidLicenseException2) {
                try {
                    license = LicenseExtractorV4.extractLicense(licenseKey);
                }
                catch (InvalidLicenseException invalidLicenseException3) {
                    try {
                        license = LicenseExtractorV3.extractLicense(licenseKey);
                    }
                    catch (InvalidLicenseException invalidLicenseException4) {
                        try {
                            license = LicenseExtractorV2.extractLicense(licenseKey);
                        }
                        catch (InvalidLicenseException invalidLicenseException5) {
                            String string;
                            license = LicenseExtractorV7.extractLicense(string);
                        }
                    }
                }
            }
        }
        int n = LicenseHelper.extractHazelcastMajorMinorVersionAsInt((String)var1_2);
        if (license.getHazelcastVersion() != 99 && license.getHazelcastVersion() != n) {
            throw new InvalidLicenseException("This license cannot work with your hazelcast version!");
        }
        if (license.isTrial() && LicenseHelper.isExpired(license)) {
            throw new InvalidLicenseException("Trial license has expired! Please contact your sales representative or contact support@hazelcast.com");
        }
        if (LicenseHelper.isExpired(license)) {
            throw new InvalidLicenseException("Enterprise License has expired! Please contact your sales representative or contact support@hazelcast.com");
        }
        return license;
    }

    public static License getBuiltInLicense() {
        Object object = new BuiltInLicenseProviderFactory();
        if ((object = ((BuiltInLicenseProviderFactory)object).create()) != null) {
            return object.provide();
        }
        return null;
    }

    public static boolean isBuiltInLicense(License license) {
        if (license != null) {
            License license2;
            return license.getVersion() == LicenseVersion.V7 && license.isOem() && license.getKey() == null && license.getCreationDate() == null && Instant.ofEpochMilli(Long.MAX_VALUE).atZone(ZoneOffset.UTC).equals(license2.getExpiryDate());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void checkLicensePerFeature(License license, Feature feature) {
        if (!license.getFeatures().contains(feature)) {
            void var1_1;
            throw new InvalidLicenseException("The Feature " + var1_1.getText() + " is not enabled for your license key. Please contact your sales representative or contact support@hazelcast.com");
        }
    }
}

