/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.ExtractorUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public final class LicenseExtractorV2 {
    public static final int RESERVED = 25;

    private LicenseExtractorV2() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        String string;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        Object[] objectArray = licenseKey.split("#");
        if (ExtractorUtils.LENGTH != (objectArray = (Object[])objectArray[objectArray.length - 1].toCharArray()).length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] cArray = new char[ExtractorUtils.LENGTH];
        System.arraycopy(objectArray, 0, cArray, 0, ExtractorUtils.LENGTH);
        char c = cArray[24];
        cArray[24] = '\u0000';
        char c2 = cArray[25];
        cArray[25] = '\u0000';
        char[] cArray2 = ExtractorUtils.hash(cArray);
        if (cArray2[0] != c || cArray2[cArray2.length - 1] != c2) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        c = cArray[0];
        char c3 = c;
        c = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)] == '1' ? (char)'\u0001' : '\u0000';
        c3 = c2 = cArray[1];
        c2 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        char c4 = cArray[2];
        char c5 = cArray[3];
        c3 = c4;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n = LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c5;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        c4 = n + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c5 = cArray[4];
        char c6 = cArray[5];
        c3 = c5;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n2 = LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c6;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        c5 = n2 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c6 = cArray[6];
        char c7 = cArray[7];
        c3 = c6;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n3 = 2000 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c7;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        c6 = n3 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c7 = cArray[8];
        char c8 = cArray[9];
        char c9 = cArray[10];
        char c10 = cArray[11];
        c3 = c7;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n4 = LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 1000;
        c3 = c8;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n5 = n4 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 100;
        c3 = c9;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n6 = n5 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c10;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        c7 = n6 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c8 = cArray[12];
        c9 = cArray[13];
        c10 = cArray[14];
        char c11 = cArray[15];
        c3 = c8;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c3 = c9;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c3 = c10;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c3 = c11;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        c8 = cArray[16];
        c9 = cArray[17];
        c10 = cArray[18];
        c11 = cArray[19];
        char c12 = cArray[20];
        char c13 = cArray[21];
        char c14 = cArray[22];
        char c15 = cArray[23];
        c3 = c8;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n7 = LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 1000000;
        c3 = c9;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n8 = n7 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 1000000;
        c3 = c10;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n9 = n8 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 100000;
        c3 = c11;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n10 = n9 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 10000;
        c3 = c12;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n11 = n10 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 1000;
        c3 = c13;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n12 = n11 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 100;
        c3 = c14;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n13 = n12 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c15;
        c3 = cArray[LicenseExtractorV2.a(ExtractorUtils.CHARS, c3)];
        int n14 = n13 + LicenseExtractorV2.a(ExtractorUtils.DIGITS, c3);
        return License.builder().key(string).expiryDate(LocalDate.of((int)c6, c5, (int)c4).atTime(LocalTime.MAX).atZone(ZoneOffset.UTC)).trial(c != '\u0000').allowedNumberOfNodes(c7).allowedNativeMemorySize(n14).hazelcastVersion(99).version(LicenseVersion.V2).features(ExtractorUtils.a(c2, LicenseVersion.V2)).build();
    }

    private static int a(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }
}

