/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobProxy;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public class JetInstanceImpl
extends AbstractJetInstance<Address> {
    private final NodeEngineImpl nodeEngine;
    private final JetConfig config;

    JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super(hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.config = config;
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    public Address getMasterId() {
        return Preconditions.checkNotNull(this.nodeEngine.getMasterAddress(), "Cluster has not elected a master");
    }

    @Override
    protected Map<Address, GetJobIdsOperation.GetJobIdsResult> getAllJobs() {
        return this.getJobsById(null);
    }

    @Override
    protected GetJobIdsOperation.GetJobIdsResult getJobByName(String name) {
        GetJobIdsOperation masterOperation = new GetJobIdsOperation(name, Long.MIN_VALUE, false);
        InvocationFuture<GetJobIdsOperation.GetJobIdsResult> masterFuture = this.nodeEngine.getOperationService().createMasterInvocationBuilder("hz:impl:jetService", masterOperation).invoke();
        return this.getJobIdsResultSafe(masterFuture);
    }

    @Override
    protected Map<Address, GetJobIdsOperation.GetJobIdsResult> getJobsById(@Nullable Long jobId) {
        long jobIdParameter = Objects.requireNonNullElse(jobId, Long.MIN_VALUE);
        GetJobIdsOperation masterOperation = new GetJobIdsOperation(null, jobIdParameter, false);
        Invocation masterInvocation = this.nodeEngine.getOperationService().createMasterInvocationBuilder("hz:impl:jetService", masterOperation).build();
        InvocationFuture masterFuture = masterInvocation.invoke();
        Supplier<Operation> operationSupplier = () -> new GetJobIdsOperation(null, jobIdParameter, true);
        CompletableFuture<Map> allMembersFuture = InvocationUtil.invokeAndReduceOnAllClusterMembers(this.nodeEngine, operationSupplier, (result, e) -> {
            if (e == null) {
                return result;
            }
            if (ExceptionUtil.isOrHasCause(e, MemberLeftException.class) || ExceptionUtil.isOrHasCause(e, TargetNotMemberException.class) || ExceptionUtil.isOrHasCause(e, HazelcastInstanceNotActiveException.class)) {
                return GetJobIdsOperation.GetJobIdsResult.EMPTY;
            }
            if (ExceptionUtil.isOrHasCause(e, InterruptedException.class)) {
                return GetJobIdsOperation.GetJobIdsResult.EMPTY;
            }
            throw new JetException("Error when getting job IDs: " + String.valueOf(e), (Throwable)e);
        }, memberMap -> memberMap.entrySet().stream().collect(Collectors.toMap(en -> ((Member)en.getKey()).getAddress(), en -> (GetJobIdsOperation.GetJobIdsResult)en.getValue())));
        GetJobIdsOperation.GetJobIdsResult masterResult = this.getJobIdsResultSafe(masterFuture);
        try {
            Map allMemberResults = allMembersFuture.get();
            allMemberResults.put(masterInvocation.getTargetAddress(), masterResult);
            return allMemberResults;
        }
        catch (InterruptedException | ExecutionException e2) {
            throw ExceptionUtil.rethrow(e2);
        }
    }

    private GetJobIdsOperation.GetJobIdsResult getJobIdsResultSafe(CompletableFuture<GetJobIdsOperation.GetJobIdsResult> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return GetJobIdsOperation.GetJobIdsResult.EMPTY;
        }
        catch (ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            JetServiceBackend jetServiceBackend = (JetServiceBackend)this.nodeEngine.getService("hz:impl:jetService");
            jetServiceBackend.shutDownJobs();
            super.shutdown();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return this.nodeEngine.getProxyService().existsDistributedObject(serviceName, objectName);
    }

    @Override
    public Job newJobProxy(long jobId, Address lightJobCoordinator) {
        return new JobProxy(this.nodeEngine, jobId, lightJobCoordinator);
    }

    @Override
    public Job newJobProxy(long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config, @Nullable Subject subject) {
        return new JobProxy(this.nodeEngine, jobId, isLightJob, jobDefinition, config, subject);
    }

    @Override
    public ILogger getLogger() {
        return this.nodeEngine.getLogger(this.getClass());
    }
}

