/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.jet.JetMemberSelector;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.EnterpriseMasterContext;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.MasterContext;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.util.LicenseHelper;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class EnterpriseJobCoordinationService
extends JobCoordinationService {
    private final Counter isolatedJobSubmitted = MwCounter.newMwCounter();

    EnterpriseJobCoordinationService(NodeEngineImpl nodeEngine, JetServiceBackend jetServiceBackend, JetConfig config, JobRepository jobRepository) {
        super(nodeEngine, jetServiceBackend, config, jobRepository);
    }

    @Override
    MasterContext createMasterContext(JobRecord jobRecord, JobExecutionRecord jobExecutionRecord) {
        return new EnterpriseMasterContext(this.nodeEngine(), this, jobRecord, jobExecutionRecord);
    }

    @Override
    public EnterpriseMasterContext getMasterContext(long jobId) {
        return (EnterpriseMasterContext)super.getMasterContext(jobId);
    }

    public CompletableFuture<Void> exportSnapshot(long jobId, String name, boolean cancelJob) {
        CompletableFuture<CompletableFuture> future = this.submitToCoordinatorThread(() -> {
            this.assertIsMaster("Cannot export snapshot for job " + Util.idToString(jobId) + " from non-master node");
            EnterpriseMasterContext masterContext = this.getMasterContext(jobId);
            if (masterContext == null) {
                throw new JobNotFoundException("MasterContext not found to export snapshot of job " + Util.idToString(jobId));
            }
            return masterContext.snapshotContext().exportSnapshot(name, cancelJob);
        });
        return future.thenCompose(Function.identity());
    }

    @Override
    protected void validateIsolatedJob(@Nonnull JetMemberSelector memberSelector) {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.nodeEngine().getNode().getNodeExtension();
        LicenseHelper.checkLicensePerFeature(nodeExtension.getLicense(), Feature.ADVANCED_COMPUTE);
        if (this.nodeEngine().getClusterService().getMembers(memberSelector::testEx).isEmpty()) {
            throw new RejectedExecutionException("No member selected with memberSelector[" + String.valueOf(memberSelector) + "]");
        }
    }

    @Override
    protected void onJobSubmitted(DAG dag) {
        super.onJobSubmitted(dag);
        if (dag.memberSelector() != null) {
            this.isolatedJobSubmitted.inc();
        }
    }

    public long getIsolatedJobSubmittedCount() {
        return this.isolatedJobSubmitted.get();
    }

    @Override
    MembersView membersView(JetMemberSelector memberSelector) {
        if (memberSelector == null) {
            return super.membersView(memberSelector);
        }
        MemberMap memberMap = this.nodeEngine().getNode().getClusterService().getMembershipManager().getMemberMap();
        List<MemberImpl> selected = memberMap.getMembers().stream().filter(memberSelector::testEx).toList();
        if (selected.isEmpty()) {
            throw new RestartableException("No member selected with memberSelector");
        }
        return MembersView.createNew(memberMap.getVersion(), selected);
    }
}

