/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class BroadcastKey<K> {
    private final K key;

    private BroadcastKey(@Nonnull K key) {
        Preconditions.checkNotNull(key, "key");
        this.key = key;
    }

    @Nonnull
    public K key() {
        return this.key;
    }

    @Nonnull
    public static <K> BroadcastKey<K> broadcastKey(@Nonnull K key) {
        return new BroadcastKey<K>(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastKey that = (BroadcastKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return "BroadcastKey{key=" + String.valueOf(this.key) + "}";
    }
}

