/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.LicenseMemoryChecker;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.util.phonehome.EnterprisePhoneHomeMetrics;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.license.domain.License;
import com.hazelcast.memory.MemoryUnit;
import java.util.BitSet;

class EnterpriseStorageMetricsProvider
implements MetricsProvider {
    EnterpriseStorageMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        this.memory(node, context);
        this.tieredStorage(node, context);
    }

    private void memory(Node node, MetricsCollectionContext context) {
        ClusterServiceImpl clusterService = node.getClusterService();
        NativeMemoryConfig memoryConfig = node.getConfig().getNativeMemoryConfig();
        long nativeMemoryCapacityBytes = (long)clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) * memoryConfig.getCapacity().bytes();
        long nativeMemoryCapacityGB = MemoryUnit.BYTES.toGigaBytes(nativeMemoryCapacityBytes);
        context.collect(EnterprisePhoneHomeMetrics.HD_MEMORY_CAPACITY, nativeMemoryCapacityGB);
        LicenseMemoryChecker checker = ((EnterpriseNodeExtension)node.getNodeExtension()).getLicenseMemoryChecker();
        BitSet hdFlags = checker.getHdMemoryLimitFlags();
        for (int i = 2; i >= 0; --i) {
            if (!hdFlags.get(i)) continue;
            context.collect(EnterprisePhoneHomeMetrics.HD_MEMORY_REACHED_LIMIT, LicenseMemoryChecker.memoryBitFlagToLimit(i));
            break;
        }
    }

    private void tieredStorage(Node node, MetricsCollectionContext context) {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)node.getNodeExtension();
        License license = nodeExtension.getLicense();
        context.collect(EnterprisePhoneHomeMetrics.TIERED_STORAGE_LIMIT, license.getAllowedTieredStoreSize());
        boolean tieredStorageEnabled = node.getConfig().getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
        if (tieredStorageEnabled) {
            TieredStoreServiceImpl tieredStoreService = (TieredStoreServiceImpl)node.getNodeEngine().getService("hz:ee:tieredStoreServiceImpl");
            long hlogLength = tieredStoreService.getMetrics().getPerMemberMetrics().getLastSeenHybridLogLength();
            context.collect(EnterprisePhoneHomeMetrics.TIERED_STORAGE_USAGE, hlogLength);
            if (node.isMaster()) {
                LicenseMemoryChecker checker = nodeExtension.getLicenseMemoryChecker();
                context.collect(EnterprisePhoneHomeMetrics.MAX_TIERED_STORAGE_USAGE, checker.getMaxTSMemoryConsumption());
                BitSet tsFlags = checker.getTsMemoryLimitFlags();
                for (int i = 2; i >= 0; --i) {
                    if (!tsFlags.get(i)) continue;
                    context.collect(EnterprisePhoneHomeMetrics.TIERED_STORAGE_REACHED_LIMIT, LicenseMemoryChecker.memoryBitFlagToLimit(i));
                    break;
                }
            }
        }
    }
}

