/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.atomiclong.AtomicLongService;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefService;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatchService;
import com.hazelcast.cp.internal.datastructures.lock.LockService;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.EnterprisePhoneHomeMetrics;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;

class CPSubsystemMetricsProvider
implements MetricsProvider {
    CPSubsystemMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        int cpMemberCount = node.getNodeEngine().getConfig().getCPSubsystemConfig().getCPMemberCount();
        boolean cpSubsystemEnabled = cpMemberCount != 0;
        context.collect(EnterprisePhoneHomeMetrics.CP_SUBSYSTEM_ENABLED, cpSubsystemEnabled);
        if (cpSubsystemEnabled) {
            context.collect(EnterprisePhoneHomeMetrics.CP_MEMBERS_COUNT, cpMemberCount);
            RaftService raftService = (RaftService)node.getNodeEngine().getService("hz:core:raft");
            int groupsCount = raftService.getMetadataGroupManager().getGroupIds().size();
            context.collect(EnterprisePhoneHomeMetrics.CP_GROUPS_COUNT, groupsCount);
            SemaphoreService semaphoreService = (SemaphoreService)node.getNodeEngine().getService("hz:raft:semaphoreService");
            int semaphoresCount = semaphoreService.getTotalResourcesCount();
            context.collect(EnterprisePhoneHomeMetrics.CP_SEMAPHORES_COUNT, semaphoresCount);
            CountDownLatchService clService = (CountDownLatchService)node.getNodeEngine().getService("hz:raft:countDownLatchService");
            int clCount = clService.getTotalResourcesCount();
            context.collect(EnterprisePhoneHomeMetrics.CP_COUNTDOWN_LATCHES_COUNT, clCount);
            LockService lockService = (LockService)node.getNodeEngine().getService("hz:raft:lockService");
            int locksCount = lockService.getTotalResourcesCount();
            context.collect(EnterprisePhoneHomeMetrics.CP_FENCED_LOCKS_COUNT, locksCount);
            AtomicLongService atomicLongService = (AtomicLongService)node.getNodeEngine().getService("hz:raft:atomicLongService");
            int atomicLongsCount = atomicLongService.getAtomicValuesCount();
            context.collect(EnterprisePhoneHomeMetrics.CP_ATOMIC_LONGS_COUNT, atomicLongsCount);
            AtomicRefService atomicRefService = (AtomicRefService)node.getNodeEngine().getService("hz:raft:atomicRefService");
            int atomicRefsCount = atomicRefService.getAtomicValuesCount();
            context.collect(EnterprisePhoneHomeMetrics.CP_ATOMIC_REFS_COUNT, atomicRefsCount);
        }
    }
}

