/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.tpcengine.util.JVM;
import com.hazelcast.internal.tpcengine.util.OS;
import com.hazelcast.internal.util.ExceptionUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public final class ICMPHelper {
    private ICMPHelper() {
    }

    private static native boolean isRawSocketPermitted0();

    public static boolean isRawSocketPermitted() {
        return ICMPHelper.isRawSocketPermitted0();
    }

    private static String extractBundledLib() {
        String string;
        block8: {
            InputStream src = IOUtil.getFileFromResourcesAsStream(ICMPHelper.getBundledLibraryPath());
            try {
                File dest = File.createTempFile("hazelcast-libicmp-helper-", ".so");
                Files.copy(src, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                string = dest.getAbsolutePath();
                if (src == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            src.close();
        }
        return string;
    }

    private static String getBundledLibraryPath() {
        if (!OS.isUnixFamily()) {
            throw new IllegalStateException("ICMP not supported in this platform: " + OS.osName());
        }
        return JVM.is32bit() ? "lib/linux-x86/libicmp_helper.so" : "lib/linux-x86_64/libicmp_helper.so";
    }

    static {
        System.load(ICMPHelper.extractBundledLib());
    }
}

