/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.PaddingUtil;
import com.hazelcast.logging.ILogger;
import java.lang.invoke.VarHandle;

public final class TStoreUtil {
    private TStoreUtil() {
    }

    static String prettyFormatPhysical(long physicalAddress) {
        return "phys:0x0" + PaddingUtil.leftPadWithZero(Long.toHexString(physicalAddress), 8);
    }

    static <T> boolean monotonicUpdate(T obj, VarHandle handle, long newValue) {
        return TStoreUtil.monotonicUpdate(obj, handle, newValue, LongValueUpdateCallback.NOP_CALLBACK);
    }

    static <T> boolean monotonicUpdate(T obj, VarHandle handle, long newValue, LongValueUpdateCallback callback) {
        long oldValue;
        do {
            if ((oldValue = handle.get(obj)) < newValue) continue;
            return false;
        } while (!handle.compareAndSet(obj, oldValue, newValue));
        callback.onValueChange(oldValue, newValue);
        return true;
    }

    static <T> boolean monotonicUpdate(T obj, VarHandle varHandle, int newValue) {
        return TStoreUtil.monotonicUpdate(obj, varHandle, newValue, IntValueUpdateCallback.NOP_CALLBACK);
    }

    static <T> boolean monotonicUpdate(T obj, VarHandle varHandle, int newValue, IntValueUpdateCallback callback) {
        int oldValue;
        do {
            if ((oldValue = varHandle.get(obj)) < newValue) continue;
            return false;
        } while (!varHandle.compareAndSet(obj, oldValue, newValue));
        callback.onValueChange(oldValue, newValue);
        return true;
    }

    static boolean monotonicUpdateNativeInt(long address, int newValue) {
        int oldValue;
        do {
            if ((oldValue = GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(address)) < newValue) continue;
            return false;
        } while (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapInt(address, oldValue, newValue));
        return true;
    }

    static long align8Bytes(long address) {
        return address + (8L - (address & 7L) & 7L);
    }

    public static int padTo8Bytes(int size) {
        return size + (8 - (size & 7) & 7);
    }

    static String hybridLogStr(String hybridLogId) {
        return "hlog:'" + hybridLogId + "'";
    }

    static String epochStr(Epoch epoch) {
        String epochStr;
        if (epoch.isCurrentThreadRegistered()) {
            long threadEpoch = epoch.getThreadEpoch(epoch.getCurrentThreadIndex());
            epochStr = Long.toString(threadEpoch);
        } else {
            epochStr = "N/A";
        }
        return "epoch:" + epochStr;
    }

    static void zeroBlock(long physicalAddress, int size) {
        GlobalMemoryAccessorRegistry.AMEM.setMemory(physicalAddress, size, (byte)0);
    }

    static String loggingAssertMessage(ILogger logger, String messageTemplate, Object ... params) {
        String message = String.format(messageTemplate, params);
        logger.severe(message, new RuntimeException("For logging"));
        return message;
    }

    static interface LongValueUpdateCallback {
        public static final LongValueUpdateCallback NOP_CALLBACK = (oldValue, newValue) -> {};

        public void onValueChange(long var1, long var3);
    }

    static interface IntValueUpdateCallback {
        public static final IntValueUpdateCallback NOP_CALLBACK = (oldValue, newValue) -> {};

        public void onValueChange(int var1, int var2);
    }
}

