/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.tstore.PaddingUtil;
import com.hazelcast.internal.tstore.hybridlog.HybridLogConfiguration;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogMessagePrologueFunction;
import com.hazelcast.internal.tstore.hybridlog.impl.MultiStageEpochAction;
import com.hazelcast.internal.tstore.hybridlog.impl.PageHeaderSupport;
import com.hazelcast.internal.tstore.hybridlog.impl.PageMetadata;
import com.hazelcast.internal.tstore.hybridlog.impl.PageMetadataStore;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import com.hazelcast.internal.tstore.hybridlog.impl.PageState;
import com.hazelcast.internal.tstore.hybridlog.impl.PageStateMachine;
import com.hazelcast.internal.tstore.hybridlog.impl.ScheduleEpochBumpFunction;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.util.MutableLong;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicInteger;

class Pager
implements Disposable {
    static final VarHandle FLUSHED_UNTIL_PAGE = ReflectionUtil.findVarHandle("flushedUntilPage", Integer.TYPE);
    static final VarHandle FLUSHING_UNTIL_PAGE = ReflectionUtil.findVarHandle("flushingUntilPage", Integer.TYPE);
    static final VarHandle TAIL_PAGE = ReflectionUtil.findVarHandle("tailPage", Integer.TYPE);
    static final VarHandle HEAD_PAGE = ReflectionUtil.findVarHandle("headPage", Integer.TYPE);
    private static final int PADDING_LOG_ADDRESS = 8;
    final int pageSize;
    final int pageMask;
    final int offsetMask;
    final int totalPages;
    final int pageSizeBits;
    final int readOnlyPages;
    final int mutablePages;
    final int pagesCapacity;
    final AtomicInteger pinnedPages = new AtomicInteger();
    final PageStateMachine pageStateMachine;
    volatile int flushedUntilPage;
    volatile int flushingUntilPage;
    volatile int closedUntilPage;
    volatile int tailPage;
    volatile int headPage;
    private final AtomicInteger acquiredPages = new AtomicInteger();
    private final ILogger logger = Logger.getLogger(Pager.class);
    private final PagePool pagePool;
    private final PageMetadataStore metadataStore;
    private final ScheduleEpochBumpFunction scheduleEpochBumpFn;
    private final HybridLogMessagePrologueFunction logPrologueFn;
    private final boolean fineEnabled;

    Pager(PagePool pagePool, HybridLogConfiguration config, ScheduleEpochBumpFunction scheduleEpochBumpFn, HybridLogMessagePrologueFunction logPrologueFn) {
        this.pageSize = config.getPageSize();
        this.scheduleEpochBumpFn = scheduleEpochBumpFn;
        this.logPrologueFn = logPrologueFn;
        this.offsetMask = this.pageSize - 1;
        this.readOnlyPages = config.getReadOnlyPages();
        this.mutablePages = config.getMutablePages();
        this.pagePool = pagePool;
        this.totalPages = this.readOnlyPages + this.mutablePages;
        this.pageMask = ~this.offsetMask;
        this.pageSizeBits = QuickMath.log2(this.pageSize);
        this.pagesCapacity = config.getBorrowCapacityScale() * this.totalPages;
        this.metadataStore = new PageMetadataStore(this.pagesCapacity);
        this.pageStateMachine = new PageStateMachine(logPrologueFn, this::prettyFormatPage);
        this.fineEnabled = this.logger.isFineEnabled();
    }

    long asLogicalAddress(int page, int offset) {
        return (long)page << this.pageSizeBits | (long)offset;
    }

    int pageOf(long logicalAddress) {
        return (int)((logicalAddress & (long)this.pageMask) >> this.pageSizeBits);
    }

    int offsetOf(long logicalAddress) {
        return (int)(logicalAddress & (long)this.offsetMask);
    }

    int pageIndex(int page) {
        return this.metadataStore.pageIndex(page);
    }

    long asPhysicalAddress(long logicalAddress) {
        int page = this.pageOf(logicalAddress);
        int offset = this.offsetOf(logicalAddress);
        long pageAddress = this.pageAddress(page);
        return pageAddress + (long)offset;
    }

    long pageAddress(int page) {
        PageMetadata meta = this.metadataStore.pageMetadata(page);
        assert (meta.page() == page) : "unexpected page";
        return meta.physicalAddress();
    }

    long pageFirstSlotAddress(int page) {
        assert (this.verifyPage(page));
        return this.asLogicalAddress(page, 8);
    }

    long pageLastSlotAddress(int page) {
        assert (this.verifyPage(page));
        int lastOffset = PageHeaderSupport.readLastAllocatedOffset(this.pageAddress(page));
        return this.asLogicalAddress(page, lastOffset);
    }

    PageState pageState(int page) {
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        if (page != pageMetadata.page()) {
            return PageState.NOT_BACKED;
        }
        return pageMetadata.state();
    }

    boolean preparePage(int page) {
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        PageState pageState = pageMetadata.state();
        return (pageState == PageState.READY && pageMetadata.page() == page || pageState == PageState.NOT_BACKED && this.assignPage(page)) && this.activatePage(page);
    }

    PageMetadata pageMetadata(long logicalAddress) {
        return this.metadataStore.pageMetadata(this.pageOf(logicalAddress));
    }

    PageMetadata pageMetadata(int page) {
        return this.metadataStore.pageMetadata(page);
    }

    PageMetadata pageMetadataNoDetached(int page) {
        return this.metadataStore.pageMetadataNoDetached(page);
    }

    private boolean assignPage(int page) {
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        MutableLong addressToRelease = new MutableLong();
        return this.pageStateMachine.assign(page, pageMetadata, () -> {
            long pagePhysicalAddress;
            try {
                pagePhysicalAddress = this.acquirePage();
            }
            catch (NativeOutOfMemoryError e) {
                this.logger.severe(this.logPrologueFn.prologue() + " - Unable to allocate physical page for hybrid log page [" + e.getMessage() + "]" + this.prettyFormatPage(page, pageMetadata));
                return false;
            }
            if (pageMetadata.casPhysicalAddress(0L, pagePhysicalAddress)) {
                if (this.fineEnabled) {
                    this.logger.fine(this.logPrologueFn.prologue() + " - Assigned physical page at " + TStoreUtil.prettyFormatPhysical(pagePhysicalAddress) + " to back logical" + this.prettyFormatPage(page, pageMetadata));
                }
                return pageMetadata.prepareFor(page);
            }
            addressToRelease.value = pagePhysicalAddress;
            return false;
        }, () -> {
            if (addressToRelease.value != 0L) {
                this.releasePage(addressToRelease.value);
            }
        });
    }

    private boolean activatePage(int page) {
        boolean activated;
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        boolean bl = activated = pageMetadata.page() == page && this.pageStateMachine.activate(pageMetadata);
        if (activated) {
            TStoreUtil.monotonicUpdate(this, TAIL_PAGE, page);
        }
        return activated;
    }

    void recycleOrDetachPage(int page) {
        assert (page >= 0) : TStoreUtil.loggingAssertMessage(this.logger, "Attempt to recycle invalid page '%d'", page);
        this.recycleOrDetachPage(this.pageMetadata(page));
    }

    boolean recycleOrDetachPage(PageMetadata pageMetadata) {
        try {
            int borrowedPages = this.borrowedPages();
            boolean recycled = borrowedPages > 0 ? this.releaseOrDetachPage(pageMetadata) : this.recycleOrDetachPage0(pageMetadata);
            if (recycled) {
                this.finishUpRetiring(pageMetadata);
            }
            return recycled;
        }
        catch (Exception ex) {
            this.logger.severe(ex.getMessage(), ex);
            throw ex;
        }
    }

    private boolean releaseOrDetachPage(PageMetadata pageMetadata) {
        return this.pageStateMachine.release(pageMetadata, () -> {
            if (this.detachInDetachingState(pageMetadata)) {
                return;
            }
            if (!pageMetadata.state().isDetachedState()) {
                this.prepareForRetiring(pageMetadata);
            }
            this.releasePage0(pageMetadata, pageMetadata.physicalAddress(), true);
        }, (oldState, newState) -> {
            if (oldState == PageState.PINNED_DETACHABLE && newState == PageState.PINNED_DETACHING) {
                pageMetadata.clearAccessibleUntilEpoch();
            } else if (newState == PageState.RELEASING_DETACHED) {
                this.removeDetachedPage(pageMetadata);
            } else if (oldState == PageState.DETACHING && newState == PageState.DETACHED) {
                MultiStageEpochAction action = new MultiStageEpochAction();
                this.scheduleEpochBumpFn.scheduleEpochBump(action, futureEpoch -> this.markPageReleasable(pageMetadata.page(), futureEpoch, action, true));
            }
        });
    }

    private void prepareForRetiring(PageMetadata pageMetadata) {
        this.metadataStore.prepareForRetiring(pageMetadata);
    }

    void finishUpRetiring(PageMetadata pageMetadata) {
        this.metadataStore.finishUpRetiring(pageMetadata);
    }

    private void releasePage0(PageMetadata pageMetadata, long pagePhysicalAddress, boolean hardRelease) {
        int page = pageMetadata.page();
        if (hardRelease) {
            if (pagePhysicalAddress == 0L) {
                throw new IllegalArgumentException(this.logPrologueFn.prologue() + " - Attempted to release physical page backing " + this.prettyFormatPage(page, pageMetadata) + " with physical page address " + TStoreUtil.prettyFormatPhysical(pagePhysicalAddress));
            }
            this.releasePage(pagePhysicalAddress);
        }
        if (this.fineEnabled) {
            this.logger.fine(this.logPrologueFn.prologue() + " - Released physical page at " + TStoreUtil.prettyFormatPhysical(pagePhysicalAddress) + " backing logical " + this.prettyFormatPage(page, pageMetadata));
        }
        TStoreUtil.monotonicUpdate(this, HEAD_PAGE, page + 1);
    }

    private boolean recycleOrDetachPage0(PageMetadata pageMetadata) {
        long pagePhysicalAddress = pageMetadata.physicalAddress();
        return this.pageStateMachine.release(pageMetadata, () -> {
            if (this.detachInDetachingState(pageMetadata)) {
                return;
            }
            if (!pageMetadata.state().isDetachedState()) {
                this.prepareForRetiring(pageMetadata);
            }
            this.releasePage0(pageMetadata, pagePhysicalAddress, false);
            for (int probes = 1; this.borrowedPages() == 0 && probes < this.pagesCapacity - 1; ++probes) {
                int candidatePage = this.tailPage + probes;
                PageMetadata candidatePageMetadata = this.metadataStore.pageMetadata(candidatePage);
                PageState candidatePageState = candidatePageMetadata.state();
                long candidatePagePhysicalAddress = candidatePageMetadata.physicalAddress();
                if (candidatePageState != PageState.NOT_BACKED || !this.pageStateMachine.assign(candidatePage, candidatePageMetadata, () -> candidatePageMetadata.casPhysicalAddress(0L, pagePhysicalAddress) && candidatePageMetadata.prepareFor(candidatePage), () -> {
                    String message = this.logPrologueFn.prologue() + " - Invalid state, there must not be any physical page assigned to logical " + this.prettyFormatPage(candidatePage, candidatePageMetadata) + ", but page with physical address " + TStoreUtil.prettyFormatPhysical(candidatePagePhysicalAddress) + " is assigned";
                    this.logger.severe(message, new IllegalStateException(message));
                })) continue;
                PageHeaderSupport.resetHighestAllocatedOffset(pagePhysicalAddress);
                if (this.fineEnabled) {
                    this.logger.fine(this.logPrologueFn.prologue() + " - Physical page at " + TStoreUtil.prettyFormatPhysical(pagePhysicalAddress) + " used to back logical " + this.prettyFormatPage(pageMetadata.page(), pageMetadata) + " has been re-assigned to logical " + this.prettyFormatPage(candidatePage, candidatePageMetadata));
                }
                return;
            }
            this.releasePage0(pageMetadata, pagePhysicalAddress, true);
        }, (oldState, newState) -> {
            if (oldState == PageState.PINNED_DETACHABLE && newState == PageState.PINNED_DETACHING) {
                pageMetadata.clearAccessibleUntilEpoch();
            } else if (newState == PageState.RELEASING_DETACHED) {
                this.removeDetachedPage(pageMetadata);
            }
        });
    }

    private boolean detachInDetachingState(PageMetadata pageMetadata) {
        if (pageMetadata.state() == PageState.PINNED_DETACHING || pageMetadata.state() == PageState.DETACHING) {
            boolean detached = this.metadataStore.detachPage(pageMetadata);
            assert (detached) : TStoreUtil.loggingAssertMessage(this.logger, "Couldn't detach page with metadata %s", pageMetadata);
            return true;
        }
        return false;
    }

    boolean markPageReadOnly(int page) {
        assert (this.verifyPage(page));
        return this.pageStateMachine.readonly(this.metadataStore.pageMetadata(page));
    }

    void markPageFlushing(int page) {
        assert (this.verifyPage(page));
        this.pageStateMachine.flush(this.metadataStore.pageMetadata(page));
    }

    void markPageFlushed(int page) {
        assert (this.verifyPage(page));
        this.pageStateMachine.flushed(this.metadataStore.pageMetadata(page));
    }

    boolean markPageReleasable(int page, long futureEpoch, MultiStageEpochAction action) {
        return this.markPageReleasable(page, futureEpoch, action, false);
    }

    boolean markPageReleasable(int page, long futureEpoch, MultiStageEpochAction action, boolean deferred) {
        assert (deferred || this.verifyPage(page));
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        if (page != pageMetadata.page()) {
            return false;
        }
        return this.pageStateMachine.releasable(pageMetadata, (oldState, newState) -> {
            switch (newState) {
                case MARKING_RELEASABLE: {
                    pageMetadata.setAccessibleUntilEpoch(futureEpoch);
                    break;
                }
                case MARKING_RELEASABLE_DETACHED: {
                    pageMetadata.setAccessibleUntilEpoch(futureEpoch);
                    break;
                }
                case PINNED_MARKING_DETACHABLE: {
                    pageMetadata.clearAccessibleUntilEpoch();
                    break;
                }
                case RELEASABLE_DETACHED: {
                    action.addStage(actionEpoch -> {
                        if (pageMetadata.accessibleUntilEpoch() == actionEpoch) {
                            this.releaseDetached(page, pageMetadata);
                        }
                    });
                    break;
                }
                case RELEASABLE: 
                case PINNED_DETACHABLE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled state: " + String.valueOf((Object)newState));
                }
            }
        });
    }

    boolean pinPage(int page) {
        return this.pinPage(page, PageStateMachine.PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    boolean pinPage(int page, PageStateMachine.PageStateTransitionObserver transitionObserver) {
        assert (this.verifyPage(page));
        PageStateMachine.PinSuccessState successState = this.pageStateMachine.pinPage(this.metadataStore.pageMetadata(page), transitionObserver);
        if (successState == PageStateMachine.PinSuccessState.PINNED) {
            this.pinnedPages.getAndIncrement();
        }
        return successState.endsInPinnedPage();
    }

    boolean pinPageForUpdate(int page) {
        assert (this.verifyPage(page));
        PageStateMachine.PinSuccessState successState = this.pageStateMachine.pinPageForUpdate(this.metadataStore.pageMetadata(page));
        if (successState == PageStateMachine.PinSuccessState.PINNED) {
            this.pinnedPages.getAndIncrement();
        }
        return successState.endsInPinnedPage();
    }

    void unpinPage(int page) {
        assert (this.verifyPage(page));
        this.unpinPage(this.metadataStore.pageMetadata(page));
    }

    void unpinPage(PageMetadata pageMetadata) {
        this.pageStateMachine.unpinPage(pageMetadata, (oldState, newState) -> this.pinnedPages.getAndDecrement());
    }

    void releaseDetached(int page, PageMetadata pageMetadata) {
        if (this.fineEnabled) {
            this.logger.fine(this.logPrologueFn.prologue() + " - Releasing detached page " + page + " with " + String.valueOf(pageMetadata));
        }
        this.recycleOrDetachPage(pageMetadata);
    }

    void demoteForUpdatePin(int page) {
        assert (this.verifyPage(page));
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        assert (pageMetadata.state() == PageState.PINNED_FOR_UPDATE);
        this.pageStateMachine.demoteForUpdatePin(pageMetadata);
    }

    private long acquirePage() {
        long address = this.pagePool.acquire();
        PageHeaderSupport.resetHighestAllocatedOffset(address);
        this.acquiredPages.getAndIncrement();
        return address;
    }

    private void releasePage(long pagePhysicalAddress) {
        this.pagePool.release(pagePhysicalAddress);
        this.acquiredPages.getAndDecrement();
    }

    int acquiredPages() {
        return this.acquiredPages.get();
    }

    int borrowedPages() {
        return Math.max(this.acquiredPages() - this.capacity(), 0);
    }

    int pinnedPages() {
        return this.pinnedPages.get();
    }

    int capacity() {
        return this.totalPages;
    }

    int extendedCapacity() {
        return this.pagesCapacity;
    }

    @Override
    public void dispose() {
        this.metadataStore.foreach(pageMetadata -> {
            long pageAddress = pageMetadata.physicalAddress();
            if (pageAddress != 0L && pageMetadata.casPhysicalAddress(pageAddress, 0L)) {
                this.pagePool.release(pageAddress);
                pageMetadata.forceSetState(PageState.NOT_BACKED);
                this.acquiredPages.decrementAndGet();
            }
        });
    }

    long pageStartLogicalAddress(int page) {
        return this.asLogicalAddress(page, 0);
    }

    long pageEndLogicalAddress(int page) {
        return this.asLogicalAddress(page, this.pageSize - 1);
    }

    long pagePhysicalAddressStart(int page) {
        long pageHeadLogicalAddress = this.asLogicalAddress(page, 0);
        return this.asPhysicalAddress(pageHeadLogicalAddress);
    }

    private long pagePhysicalAddressEnd(int page) {
        long pageHeadLogicalAddress = this.asLogicalAddress(page, 0);
        return this.asPhysicalAddress(pageHeadLogicalAddress) + (long)this.pageSize - 1L;
    }

    String prettyFormat(long logicalAddress) {
        if (logicalAddress != Long.MAX_VALUE) {
            return "log:0x0" + PaddingUtil.leftPadWithZero(Long.toHexString(logicalAddress), 8) + "(page:" + this.pageOf(logicalAddress) + ",offset:" + this.offsetOf(logicalAddress) + ")";
        }
        return "log:<inf>(page:<inf>,offset:<inf>)";
    }

    String prettyFormatPage(int page, PageMetadata pageMetadata) {
        return this.metadataStore.prettyFormatPage(pageMetadata, page);
    }

    String debugInfo() {
        StringBuilder sb = new StringBuilder();
        String ln = System.lineSeparator();
        String tab = "\t";
        int headPageCopy = this.headPage;
        int tailPageCopy = this.tailPage;
        sb.append(Thread.currentThread().getName()).append(" -- Pager#debugInfo:").append(ln).append(tab).append("totalPages=").append(this.totalPages).append(ln).append(tab).append("acquiredPages=").append(this.acquiredPages()).append(ln).append(tab).append("borrowedPages=").append(this.borrowedPages()).append(ln).append(tab).append("flushedUntilPage=").append(this.flushedUntilPage).append(ln).append(tab).append("flushingUntilPage=").append(this.flushingUntilPage).append(ln).append(tab).append("closedUntilPage=").append(this.closedUntilPage).append(ln).append(tab).append("pages=").append(this.debugPages()).append(ln).append(tab).append("detachedPages=").append(this.debugDetachedPages()).append(ln).append(tab).append("headPage=").append(headPageCopy).append(ln).append(tab).append("tailPage=").append(tailPageCopy).append(ln).append(tab).append("index of headPage=").append(this.pageIndex(headPageCopy)).append(tab).append("index of tailPage=").append(this.pageIndex(tailPageCopy)).append(ln);
        return sb.toString();
    }

    private String debugPages() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        this.metadataStore.foreach((pageMetadata, ordinal) -> {
            if (ordinal != 0) {
                sb.append(",\n\t\t   ");
            }
            sb.append(ordinal).append(":\t").append(pageMetadata);
        });
        sb.append(']');
        return sb.toString();
    }

    private String debugDetachedPages() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        this.metadataStore.foreachDetached((pageMetadata, first) -> {
            if (!first.booleanValue()) {
                sb.append(",\n\t\t   ");
            }
            sb.append(pageMetadata);
        });
        sb.append(']');
        return sb.toString();
    }

    boolean verifyPage(int page) {
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        int pageFromMetadata = pageMetadata.page();
        if (page != pageFromMetadata) {
            String message = this.logPrologueFn.prologue() + " - Illegal attempt to access " + this.prettyFormatPage(page, pageMetadata) + " " + this.debugInfo();
            this.logger.severe(message, new RuntimeException("Just for logging"));
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    boolean verifyAccess(int page, long physicalAddress) {
        this.verifyPage(page);
        PageMetadata pageMetadata = this.metadataStore.pageMetadata(page);
        long pagePhysicalAddress = pageMetadata.physicalAddress();
        long pagePhysicalAddressStart = this.pagePhysicalAddressStart(page);
        long pagePhysicalAddressEnd = this.pagePhysicalAddressEnd(page);
        if (pagePhysicalAddressStart == 0L) {
            String message = this.logPrologueFn.prologue() + "- attempted to access " + this.prettyFormatPage(page, pageMetadata) + " with " + TStoreUtil.prettyFormatPhysical(physicalAddress) + ", but the given page is not backed with physical memory";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        if (pagePhysicalAddress >= pagePhysicalAddressStart && pagePhysicalAddress <= pagePhysicalAddressEnd) {
            return true;
        }
        String message = this.logPrologueFn.prologue() + " - attempted to access " + this.prettyFormatPage(page, pageMetadata) + " with " + TStoreUtil.prettyFormatPhysical(physicalAddress) + ", but the given address is not within the address range of the page";
        this.logger.severe(message);
        throw new IllegalArgumentException(message);
    }

    boolean removeDetachedPage(PageMetadata pageMetadata) {
        return this.metadataStore.removeDetachedPage(pageMetadata);
    }
}

