/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.util.QuickMath;
import java.util.Arrays;

class PagePinnedOffsets {
    static final int NOT_PINNED_OFFSET = -2;
    private static final int MASK_READ_COUNT = 65535;
    private static final int EMPTY = -1;
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private static final float DEFAULT_LOAD_FACTOR = 0.8f;
    private static final int WRITE_PIN_SHIFT = 16;
    private final float loadFactor;
    private int[] table;
    private int resizeThreshold;
    private int capacity = QuickMath.nextPowerOfTwo(4);
    private int mask;
    private int readPinCount;
    private int writePinCount;
    private int size;

    PagePinnedOffsets() {
        this.loadFactor = 0.8f;
        this.resizeThreshold = (int)((float)this.capacity * this.loadFactor);
        this.mask = 2 * this.capacity - 1;
        this.table = new int[2 * this.capacity];
        Arrays.fill(this.table, -1);
    }

    int pinOffset(int offset, PinType pinType) {
        this.ensureMeaningfulPinType(pinType);
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                if (pinType == PinType.READ) {
                    short newReadPinCount = this.changeReadCount(index + 1, 1);
                    if (newReadPinCount == 1) {
                        ++this.readPinCount;
                    }
                    return newReadPinCount;
                }
                short newWritePinCount = this.changeWriteCount(index + 1, 1);
                if (newWritePinCount == 1) {
                    ++this.writePinCount;
                }
                return newWritePinCount;
            }
            index = this.nextIndex(index);
        }
        if (pinType == PinType.READ) {
            ++this.readPinCount;
        } else {
            ++this.writePinCount;
        }
        ++this.size;
        this.table[index] = offset;
        this.table[index + 1] = pinType == PinType.READ ? PagePinnedOffsets.pack((short)1, (short)0) : PagePinnedOffsets.pack((short)0, (short)1);
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return 1;
    }

    int unpinOffset(int offset, PinType pinType) {
        this.ensureMeaningfulPinType(pinType);
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                short newCounter;
                if (this.pinCount(index + 1, pinType) == 0) {
                    return -2;
                }
                if (pinType == PinType.READ) {
                    newCounter = this.changeReadCount(index + 1, -1);
                    if (newCounter == 0) {
                        --this.readPinCount;
                    }
                } else {
                    newCounter = this.changeWriteCount(index + 1, -1);
                    if (newCounter == 0) {
                        --this.writePinCount;
                    }
                }
                if (newCounter != 0) {
                    return newCounter;
                }
                if (this.table[index + 1] == 0) {
                    this.table[index] = -1;
                    this.compactChain(index);
                    --this.size;
                }
                return 0;
            }
            index = this.nextIndex(index);
        }
        return -2;
    }

    boolean isOffsetPinned(int offset) {
        return this.isOffsetPinned(offset, PinType.READ) || this.isOffsetPinned(offset, PinType.WRITE);
    }

    boolean isOffsetPinned(int offset, PinType pinType) {
        this.ensureMeaningfulPinType(pinType);
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                return this.pinCount(index + 1, pinType) > 0;
            }
            index = this.nextIndex(index);
        }
        return false;
    }

    boolean isAnyOffsetPinned() {
        return this.size > 0;
    }

    boolean isAnyOffsetPinned(PinType pinType) {
        this.ensureMeaningfulPinType(pinType);
        if (pinType == PinType.READ) {
            return this.readPinCount > 0;
        }
        return this.writePinCount > 0;
    }

    void clear() {
        this.size = 0;
        this.readPinCount = 0;
        this.writePinCount = 0;
        Arrays.fill(this.table, -1);
    }

    int size() {
        return this.size;
    }

    PinType pagePinType() {
        if (this.writePinCount > 0) {
            return PinType.WRITE;
        }
        if (this.readPinCount > 0) {
            return PinType.READ;
        }
        return PinType.NONE;
    }

    PinType pinType(int offset) {
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                return PagePinnedOffsets.inferPinType(this.table[index + 1]);
            }
            index = this.nextIndex(index);
        }
        return PinType.NONE;
    }

    private static PinType inferPinType(int pinCounters) {
        short readPinCount = PagePinnedOffsets.readCount(pinCounters);
        short writePinCount = PagePinnedOffsets.writeCount(pinCounters);
        if (writePinCount > 0) {
            return PinType.WRITE;
        }
        if (readPinCount > 0) {
            return PinType.READ;
        }
        return PinType.NONE;
    }

    int pinCount(PinType pinType) {
        this.ensureMeaningfulPinType(pinType);
        if (pinType == PinType.READ) {
            return this.readPinCount;
        }
        return this.writePinCount;
    }

    private void ensureMeaningfulPinType(PinType pinType) {
        if (pinType != PinType.READ && pinType != PinType.WRITE) {
            throw new IllegalArgumentException("Invalid pin type for this call: " + String.valueOf((Object)pinType));
        }
    }

    private void increaseCapacity() {
        int newCapacity = this.capacity << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        this.capacity = newCapacity;
        this.mask = 2 * this.capacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] newTable = new int[2 * this.capacity];
        Arrays.fill(newTable, -1);
        for (int i = 0; i < this.table.length; i += 2) {
            int offset = this.table[i];
            int counter = this.table[i + 1];
            if (offset == -1) continue;
            int hash = Integer.hashCode(offset);
            int index = this.hash2Index(hash);
            while (newTable[index] != -1) {
                index = this.nextIndex(index);
            }
            newTable[index] = offset;
            newTable[index + 1] = counter;
        }
        this.table = newTable;
    }

    private void compactChain(int indexOfRemoved) {
        int deleteIndex;
        int index = deleteIndex = indexOfRemoved;
        while (this.table[index = this.nextIndex(index)] != -1) {
            int offset = this.table[index];
            int hash = Integer.hashCode(offset);
            int hashedIndex = this.hash2Index(hash);
            if ((index >= hashedIndex || hashedIndex > deleteIndex && deleteIndex > index) && (hashedIndex > deleteIndex || deleteIndex > index)) continue;
            this.table[deleteIndex] = this.table[index];
            this.table[deleteIndex + 1] = this.table[index + 1];
            this.table[index] = -1;
            this.table[index + 1] = -1;
            deleteIndex = index;
        }
        return;
    }

    private int nextIndex(int index) {
        return index + 2 & this.mask;
    }

    private int hash2Index(int hash) {
        return 2 * hash & this.mask;
    }

    private short changeReadCount(int index, int delta) {
        int pinCounts = this.table[index];
        short newReadCount = (short)(PagePinnedOffsets.readCount(pinCounts) + delta);
        this.table[index] = PagePinnedOffsets.pack(newReadCount, PagePinnedOffsets.writeCount(pinCounts));
        return newReadCount;
    }

    private short changeWriteCount(int index, int delta) {
        int pinCounts = this.table[index];
        short newWriteCount = (short)(PagePinnedOffsets.writeCount(pinCounts) + (short)delta);
        this.table[index] = PagePinnedOffsets.pack(PagePinnedOffsets.readCount(pinCounts), newWriteCount);
        return newWriteCount;
    }

    private int pinCount(int index, PinType pinType) {
        if (pinType == PinType.READ) {
            return PagePinnedOffsets.readCount(this.table[index]);
        }
        return PagePinnedOffsets.writeCount(this.table[index]);
    }

    private static short readCount(int pinValue) {
        return (short)(pinValue & 0xFFFF);
    }

    private static short writeCount(int pinValue) {
        return (short)(pinValue >> 16);
    }

    private static int pack(short readCount, short writeCount) {
        return writeCount << 16 | readCount;
    }
}

