/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

public final class Invariants {
    private Invariants() {
    }

    public static void inRange(int lower, int target, int upper) {
        assert (lower <= target && target <= upper) : "lower=" + lower + ", target=" + target + ", upper=" + upper;
    }

    public static void isTrue(boolean bool, String message) {
        assert (bool) : message;
    }

    public static void isFalse(boolean bool, String message) {
        assert (!bool) : message;
    }

    public static void nonNull(Object o, String message) {
        assert (o != null) : message;
    }

    public static void isNull(Object o, String message) {
        assert (o == null) : message;
    }

    public static void equals(long a2, long b) {
        assert (a2 == b) : Invariants.msg(a2, b);
    }

    public static void equals(long a2, long b, String message) {
        assert (a2 == b) : Invariants.msg(a2, b) + ", message=" + message;
    }

    public static void equals(int a2, int b) {
        assert (a2 == b) : Invariants.msg(a2, b);
    }

    public static void notEquals(long a2, long b) {
        assert (a2 != b) : Invariants.msg(a2, b);
    }

    public static void notEquals(int a2, int b) {
        assert (a2 != b) : Invariants.msg(a2, b);
    }

    public static void lessThan(long a2, long b) {
        assert (a2 < b) : Invariants.msg(a2, b);
    }

    public static void lessThan(int a2, int b) {
        assert (a2 < b) : Invariants.msg(a2, b);
    }

    public static void greaterThan(int a2, int b) {
        assert (a2 > b) : Invariants.msg(a2, b);
    }

    public static void lessThanOrEqual(long a2, long b) {
        assert (a2 <= b) : Invariants.msg(a2, b);
    }

    public static void lessThanOrEqual(int a2, int b) {
        assert (a2 <= b) : Invariants.msg(a2, b);
    }

    public static void lessThanOrEqual(int a2, int b, String message) {
        assert (a2 <= b) : Invariants.msg(a2, b) + ", message=" + message;
    }

    public static void greaterOrEqualThan(long a2, long b) {
        assert (a2 >= b) : Invariants.msg(a2, b);
    }

    public static void greaterOrEqualThan(int a2, int b) {
        assert (a2 >= b) : Invariants.msg(a2, b);
    }

    public static void greaterOrEqualThan(int a2, int b, String message) {
        assert (a2 >= b) : Invariants.msg(a2, b) + ", message=" + message;
    }

    public static void nonNegative(int a2) {
        assert (a2 >= 0) : "a=" + a2;
    }

    public static void nonNegative(int a2, String message) {
        assert (a2 >= 0) : "a=" + a2 + ", message=" + message;
    }

    public static void nonNegative(long a2) {
        assert (a2 >= 0L) : "a=" + a2;
    }

    private static String msg(long a2, long b) {
        return "a=" + a2 + ", b=" + b;
    }

    private static String msg(int a2, int b) {
        return "a=" + a2 + ", b=" + b;
    }
}

