/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.PortableUtil;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.FieldTypeToFieldKind;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PortableInternalGenericRecord
extends PortableGenericRecord
implements InternalGenericRecord {
    protected final ClassDefinition cd;
    protected final PortableSerializer serializer;
    private final BufferObjectDataInput in;
    private final int offset;
    private final int finalPosition;

    PortableInternalGenericRecord(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd) {
        int fieldCount;
        this.in = in;
        this.serializer = serializer;
        this.cd = cd;
        try {
            this.finalPosition = in.readInt();
            fieldCount = in.readInt();
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
        if (fieldCount != cd.getFieldCount()) {
            throw new IllegalStateException("Field count[" + fieldCount + "] in stream does not match " + String.valueOf(cd));
        }
        this.offset = in.position();
    }

    public final void end() {
        this.in.position(this.finalPosition);
    }

    @Override
    public ClassDefinition getClassDefinition() {
        return this.cd;
    }

    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.cd.hasField(fieldName);
    }

    @Override
    @Nonnull
    public FieldKind getFieldKind(@Nonnull String fieldName) {
        FieldType fieldType;
        try {
            fieldType = this.cd.getFieldType(fieldName);
        }
        catch (IllegalArgumentException ignored) {
            return FieldKind.NOT_AVAILABLE;
        }
        return FieldTypeToFieldKind.toFieldKind(fieldType);
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        try {
            return this.in.readBoolean(this.readPosition(fieldName, FieldType.BOOLEAN));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public byte getInt8(@Nonnull String fieldName) {
        try {
            return this.in.readByte(this.readPosition(fieldName, FieldType.BYTE));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        try {
            return this.in.readChar(this.readPosition(fieldName, FieldType.CHAR));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public double getFloat64(@Nonnull String fieldName) {
        try {
            return this.in.readDouble(this.readPosition(fieldName, FieldType.DOUBLE));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public float getFloat32(@Nonnull String fieldName) {
        try {
            return this.in.readFloat(this.readPosition(fieldName, FieldType.FLOAT));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public int getInt32(@Nonnull String fieldName) {
        try {
            return this.in.readInt(this.readPosition(fieldName, FieldType.INT));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public long getInt64(@Nonnull String fieldName) {
        try {
            return this.in.readLong(this.readPosition(fieldName, FieldType.LONG));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public short getInt16(@Nonnull String fieldName) {
        try {
            return this.in.readShort(this.readPosition(fieldName, FieldType.SHORT));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public String getString(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF);
            this.in.position(pos);
            String string = this.in.readString();
            return string;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Nullable
    private <T> T readNullableField(@Nonnull String fieldName, FieldType fieldType, Reader<ObjectDataInput, T> reader) {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, fieldType);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            if (isNull) {
                T t = null;
                return t;
            }
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return this.readNullableField(fieldName, FieldType.DECIMAL, IOUtil::readBigDecimal);
    }

    @Override
    public LocalTime getTime(@Nonnull String fieldName) {
        return this.readNullableField(fieldName, FieldType.TIME, PortableUtil::readLocalTime);
    }

    @Override
    public LocalDate getDate(@Nonnull String fieldName) {
        return this.readNullableField(fieldName, FieldType.DATE, PortableUtil::readLocalDate);
    }

    @Override
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        return this.readNullableField(fieldName, FieldType.TIMESTAMP, PortableUtil::readLocalDateTime);
    }

    @Override
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        return this.readNullableField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE, PortableUtil::readOffsetDateTime);
    }

    private boolean isNullOrEmpty(int pos) {
        return pos == -1;
    }

    @Override
    public boolean[] getArrayOfBoolean(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.BOOLEAN_ARRAY);
            if (this.isNullOrEmpty(position)) {
                boolean[] blArray = null;
                return blArray;
            }
            this.in.position(position);
            boolean[] blArray = this.in.readBooleanArray();
            return blArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public byte[] getArrayOfInt8(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.BYTE_ARRAY);
            if (this.isNullOrEmpty(position)) {
                byte[] byArray = null;
                return byArray;
            }
            this.in.position(position);
            byte[] byArray = this.in.readByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public char[] getArrayOfChar(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.CHAR_ARRAY);
            if (this.isNullOrEmpty(position)) {
                char[] cArray = null;
                return cArray;
            }
            this.in.position(position);
            char[] cArray = this.in.readCharArray();
            return cArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public double[] getArrayOfFloat64(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.DOUBLE_ARRAY);
            if (this.isNullOrEmpty(position)) {
                double[] dArray = null;
                return dArray;
            }
            this.in.position(position);
            double[] dArray = this.in.readDoubleArray();
            return dArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public float[] getArrayOfFloat32(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.FLOAT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                float[] fArray = null;
                return fArray;
            }
            this.in.position(position);
            float[] fArray = this.in.readFloatArray();
            return fArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public int[] getArrayOfInt32(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.INT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                int[] nArray = null;
                return nArray;
            }
            this.in.position(position);
            int[] nArray = this.in.readIntArray();
            return nArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public long[] getArrayOfInt64(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.LONG_ARRAY);
            if (this.isNullOrEmpty(position)) {
                long[] lArray = null;
                return lArray;
            }
            this.in.position(position);
            long[] lArray = this.in.readLongArray();
            return lArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public short[] getArrayOfInt16(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.SHORT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                short[] sArray = null;
                return sArray;
            }
            this.in.position(position);
            short[] sArray = this.in.readShortArray();
            return sArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public String[] getArrayOfString(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.UTF_ARRAY);
            if (this.isNullOrEmpty(position)) {
                String[] stringArray = null;
                return stringArray;
            }
            this.in.position(position);
            String[] stringArray = this.in.readStringArray();
            return stringArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private <T> T[] readObjectArrayField(@Nonnull String fieldName, FieldType fieldType, IntFunction<T[]> constructor, Reader<ObjectDataInput, T> reader) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, fieldType);
            if (this.isNullOrEmpty(position)) {
                T[] TArray = null;
                return TArray;
            }
            this.in.position(position);
            int len = this.in.readInt();
            if (len == -1) {
                T[] TArray = null;
                return TArray;
            }
            T[] values = constructor.apply(len);
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int pos = this.in.readInt(offset + i * 4);
                    this.in.position(pos);
                    values[i] = reader.read(this.in);
                }
            }
            T[] TArray = values;
            return TArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public BigDecimal[] getArrayOfDecimal(@Nonnull String fieldName) {
        return this.readObjectArrayField(fieldName, FieldType.DECIMAL_ARRAY, BigDecimal[]::new, IOUtil::readBigDecimal);
    }

    @Override
    public LocalTime[] getArrayOfTime(@Nonnull String fieldName) {
        return this.readObjectArrayField(fieldName, FieldType.TIME_ARRAY, LocalTime[]::new, PortableUtil::readLocalTime);
    }

    @Override
    public LocalDate[] getArrayOfDate(@Nonnull String fieldName) {
        return this.readObjectArrayField(fieldName, FieldType.DATE_ARRAY, LocalDate[]::new, PortableUtil::readLocalDate);
    }

    @Override
    public LocalDateTime[] getArrayOfTimestamp(@Nonnull String fieldName) {
        return this.readObjectArrayField(fieldName, FieldType.TIMESTAMP_ARRAY, LocalDateTime[]::new, PortableUtil::readLocalDateTime);
    }

    @Override
    public OffsetDateTime[] getArrayOfTimestampWithTimezone(@Nonnull String fieldName) {
        return this.readObjectArrayField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, OffsetDateTime[]::new, PortableUtil::readOffsetDateTime);
    }

    private void checkFactoryAndClass(FieldDefinition fd, int factoryId, int classId) {
        if (factoryId != fd.getFactoryId()) {
            throw new IllegalArgumentException("Invalid factoryId! Expected: " + fd.getFactoryId() + ", Current: " + factoryId);
        }
        if (classId != fd.getClassId()) {
            throw new IllegalArgumentException("Invalid classId! Expected: " + fd.getClassId() + ", Current: " + classId);
        }
    }

    private int readPosition(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            throw this.newUnknownFieldException(fieldName);
        }
        if (fd.getType() != fieldType) {
            throw new HazelcastSerializationException("Not a '" + String.valueOf((Object)fieldType) + "' field: " + fieldName);
        }
        return this.readPosition(fd);
    }

    private IllegalStateException newIllegalStateException(IOException e) {
        return new IllegalStateException("IOException is not expected since we read from a well known format and position", e);
    }

    private HazelcastSerializationException newUnknownFieldException(@Nonnull String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
    }

    private int readPosition(FieldDefinition fd) {
        try {
            int pos = this.in.readInt(this.offset + fd.getIndex() * 4);
            short len = this.in.readShort(pos);
            return pos + 2 + len + 1;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilderWithClone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.cd.getFieldNames();
    }

    @Override
    public GenericRecord[] getArrayOfGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord[])this.readNestedArray(fieldName, GenericRecord[]::new, PortableReadMethod.GENERIC_RECORD);
    }

    @Override
    @Nullable
    public InternalGenericRecord[] getArrayOfInternalGenericRecord(@Nonnull String fieldName) {
        return (InternalGenericRecord[])this.readNestedArray(fieldName, InternalGenericRecord[]::new, PortableReadMethod.INTERNAL_GENERIC_RECORD);
    }

    private <T> T[] readNestedArray(@Nonnull String fieldName, IntFunction<T[]> constructor, PortableReadMethod readMethod) {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.newUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int position = this.readPosition(fd);
            if (this.isNullOrEmpty(position)) {
                T[] TArray = null;
                return TArray;
            }
            this.in.position(position);
            int len = this.in.readInt();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            if (len == -1) {
                T[] TArray = null;
                return TArray;
            }
            this.checkFactoryAndClass(fd, factoryId, classId);
            T[] portables = constructor.apply(len);
            if (len > 0) {
                int offset = this.in.position();
                block12: for (int i = 0; i < len; ++i) {
                    int start = this.in.readInt(offset + i * 4);
                    this.in.position(start);
                    switch (readMethod) {
                        case OBJECT: {
                            portables[i] = this.serializer.read(this.in, factoryId, classId);
                            continue block12;
                        }
                        case GENERIC_RECORD: {
                            portables[i] = this.serializer.readAsGenericRecord(this.in, factoryId, classId);
                            continue block12;
                        }
                        case INTERNAL_GENERIC_RECORD: {
                            portables[i] = this.serializer.readAsInternalGenericRecord(this.in, factoryId, classId);
                            continue block12;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            T[] TArray = portables;
            return TArray;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.readNested(fieldName, PortableReadMethod.GENERIC_RECORD);
    }

    @Override
    @Nullable
    public InternalGenericRecord getInternalGenericRecord(@Nonnull String fieldName) {
        return (InternalGenericRecord)this.readNested(fieldName, PortableReadMethod.INTERNAL_GENERIC_RECORD);
    }

    private <T> T readNested(@Nonnull String fieldName, PortableReadMethod readMethod) {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.newUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE) {
                throw new HazelcastSerializationException("Not a Portable field: " + fieldName);
            }
            int pos = this.readPosition(fd);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            if (!isNull) {
                switch (readMethod) {
                    case OBJECT: {
                        Object t = this.serializer.read(this.in, factoryId, classId);
                        return t;
                    }
                    case GENERIC_RECORD: {
                        Object t = this.serializer.readAsGenericRecord(this.in, factoryId, classId);
                        return t;
                    }
                    case INTERNAL_GENERIC_RECORD: {
                        Object t = this.serializer.readAsInternalGenericRecord(this.in, factoryId, classId);
                        return t;
                    }
                }
                throw new IllegalStateException();
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private boolean doesNotHaveIndex(int beginPosition, int index) {
        try {
            int numberOfItems = this.in.readInt(beginPosition);
            return numberOfItems <= index;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Byte getInt8FromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.BYTE_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readByte(4 + position + index * 1);
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getBooleanFromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.BOOLEAN_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readBoolean(4 + position + index * 1);
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Character getCharFromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.CHAR_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return Character.valueOf(this.in.readChar(4 + position + index * 2));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Double getFloat64FromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.DOUBLE_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readDouble(4 + position + index * 8);
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Float getFloat32FromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.FLOAT_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return Float.valueOf(this.in.readFloat(4 + position + index * 4));
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Integer getInt32FromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.INT_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readInt(4 + position + index * 4);
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Long getInt64FromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.LONG_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readLong(4 + position + index * 8);
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public Short getInt16FromArray(@Nonnull String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.SHORT_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readShort(4 + position + index * 2);
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
    }

    @Override
    public String getStringFromArray(@Nonnull String fieldName, int index) {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF_ARRAY);
            this.in.position(pos);
            int length = this.in.readInt();
            if (length <= index) {
                String string = null;
                return string;
            }
            if (this.isNullOrEmpty(pos)) {
                String string = null;
                return string;
            }
            for (int i = 0; i < index; ++i) {
                int itemLength = this.in.readInt();
                if (itemLength <= 0) continue;
                this.in.position(this.in.position() + itemLength);
            }
            String string = this.in.readString();
            return string;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public GenericRecord getGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return (GenericRecord)this.readNestedFromArray(fieldName, index, PortableReadMethod.GENERIC_RECORD);
    }

    @Override
    @Nullable
    public InternalGenericRecord getInternalGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return (InternalGenericRecord)this.readNestedFromArray(fieldName, index, PortableReadMethod.INTERNAL_GENERIC_RECORD);
    }

    @Override
    public <T> T getObjectFromArray(@Nonnull String fieldName, int index) {
        return this.readNestedFromArray(fieldName, index, PortableReadMethod.OBJECT);
    }

    private <T> T readNestedFromArray(@Nonnull String fieldName, int index, PortableReadMethod readMethod) {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.newUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int position = this.readPosition(fd);
            if (this.isNullOrEmpty(position)) {
                T t = null;
                return t;
            }
            this.in.position(position);
            int len = this.in.readInt();
            if (len == -1 || len == 0 || len <= index) {
                T t = null;
                return t;
            }
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            int offset = this.in.position();
            int start = this.in.readInt(offset + index * 4);
            this.in.position(start);
            switch (readMethod) {
                case OBJECT: {
                    Object t = this.serializer.read(this.in, factoryId, classId);
                    return t;
                }
                case GENERIC_RECORD: {
                    Object t = this.serializer.readAsGenericRecord(this.in, factoryId, classId);
                    return t;
                }
                case INTERNAL_GENERIC_RECORD: {
                    Object t = this.serializer.readAsInternalGenericRecord(this.in, factoryId, classId);
                    return t;
                }
            }
            try {
                throw new IllegalStateException();
            }
            catch (IOException e) {
                throw this.newIllegalStateException(e);
            }
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private <T> T readObjectFromArrayField(@Nonnull String fieldName, FieldType fieldType, Reader<ObjectDataInput, T> reader, int index) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, fieldType);
            if (this.isNullOrEmpty(position)) {
                T t = null;
                return t;
            }
            this.in.position(position);
            int len = this.in.readInt();
            if (len == -1 || len == 0 || len <= index) {
                T t = null;
                return t;
            }
            int offset = this.in.position();
            int pos = this.in.readInt(offset + index * 4);
            this.in.position(pos);
            T t = reader.read(this.in);
            return t;
        }
        catch (IOException e) {
            throw this.newIllegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public BigDecimal getDecimalFromArray(@Nonnull String fieldName, int index) {
        return this.readObjectFromArrayField(fieldName, FieldType.DECIMAL_ARRAY, IOUtil::readBigDecimal, index);
    }

    @Override
    public LocalTime getTimeFromArray(@Nonnull String fieldName, int index) {
        return this.readObjectFromArrayField(fieldName, FieldType.TIME_ARRAY, PortableUtil::readLocalTime, index);
    }

    @Override
    public LocalDate getDateFromArray(@Nonnull String fieldName, int index) {
        return this.readObjectFromArrayField(fieldName, FieldType.DATE_ARRAY, PortableUtil::readLocalDate, index);
    }

    @Override
    public LocalDateTime getTimestampFromArray(@Nonnull String fieldName, int index) {
        return this.readObjectFromArrayField(fieldName, FieldType.TIMESTAMP_ARRAY, PortableUtil::readLocalDateTime, index);
    }

    @Override
    public OffsetDateTime getTimestampWithTimezoneFromArray(@Nonnull String fieldName, int index) {
        return this.readObjectFromArrayField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, PortableUtil::readOffsetDateTime, index);
    }

    @Override
    public <T> T[] getArrayOfObject(@Nonnull String fieldName, Class<T> componentType) {
        return this.readNestedArray(fieldName, length -> (Object[])Array.newInstance(componentType, length), PortableReadMethod.OBJECT);
    }

    public Object getObject(@Nonnull String fieldName) {
        return this.readNested(fieldName, PortableReadMethod.OBJECT);
    }

    @Override
    protected Object getClassIdentifier() {
        return this.cd;
    }

    @Override
    @Nullable
    public Byte getNullableInt8FromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Boolean getNullableBooleanFromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Short getNullableInt16FromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Integer getNullableInt32FromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Long getNullableInt64FromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Float getNullableFloat32FromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Double getNullableFloat64FromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    private static interface Reader<T, R> {
        public R read(T var1) throws IOException;
    }

    static enum PortableReadMethod {
        OBJECT,
        GENERIC_RECORD,
        INTERNAL_GENERIC_RECORD;

    }
}

